/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.ovr;

import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct ovrSessionStatus")
public class OVRSessionStatus
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int ISVISIBLE;
    public static final int HMDPRESENT;
    public static final int HMDMOUNTED;
    public static final int DISPLAYLOST;
    public static final int SHOULDQUIT;
    public static final int SHOULDRECENTER;
    public static final int INTERNAL;

    OVRSessionStatus(long address, ByteBuffer container) {
        super(address, container);
    }

    public OVRSessionStatus(ByteBuffer container) {
        this(MemoryUtil.memAddress((ByteBuffer)container), OVRSessionStatus.checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="ovrBool")
    public boolean IsVisible() {
        return OVRSessionStatus.nIsVisible(this.address());
    }

    @NativeType(value="ovrBool")
    public boolean HmdPresent() {
        return OVRSessionStatus.nHmdPresent(this.address());
    }

    @NativeType(value="ovrBool")
    public boolean HmdMounted() {
        return OVRSessionStatus.nHmdMounted(this.address());
    }

    @NativeType(value="ovrBool")
    public boolean DisplayLost() {
        return OVRSessionStatus.nDisplayLost(this.address());
    }

    @NativeType(value="ovrBool")
    public boolean ShouldQuit() {
        return OVRSessionStatus.nShouldQuit(this.address());
    }

    @NativeType(value="ovrBool")
    public boolean ShouldRecenter() {
        return OVRSessionStatus.nShouldRecenter(this.address());
    }

    @NativeType(value="ovrBool[2]")
    public ByteBuffer Internal() {
        return OVRSessionStatus.nInternal(this.address());
    }

    @NativeType(value="ovrBool")
    public boolean Internal(int index) {
        return OVRSessionStatus.nInternal(this.address(), index);
    }

    public static OVRSessionStatus malloc() {
        return OVRSessionStatus.create(MemoryUtil.nmemAlloc((long)SIZEOF));
    }

    public static OVRSessionStatus calloc() {
        return OVRSessionStatus.create(MemoryUtil.nmemCalloc((long)1L, (long)SIZEOF));
    }

    public static OVRSessionStatus create() {
        return new OVRSessionStatus(BufferUtils.createByteBuffer((int)SIZEOF));
    }

    public static OVRSessionStatus create(long address) {
        return address == 0L ? null : new OVRSessionStatus(address, null);
    }

    public static Buffer malloc(int capacity) {
        return OVRSessionStatus.create(OVRSessionStatus.__malloc((int)capacity, (int)SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return OVRSessionStatus.create(MemoryUtil.nmemCalloc((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(OVRSessionStatus.__create((int)capacity, (int)SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, null, -1, 0, capacity, capacity);
    }

    public static OVRSessionStatus mallocStack() {
        return OVRSessionStatus.mallocStack(MemoryStack.stackGet());
    }

    public static OVRSessionStatus callocStack() {
        return OVRSessionStatus.callocStack(MemoryStack.stackGet());
    }

    public static OVRSessionStatus mallocStack(MemoryStack stack) {
        return OVRSessionStatus.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static OVRSessionStatus callocStack(MemoryStack stack) {
        return OVRSessionStatus.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return OVRSessionStatus.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return OVRSessionStatus.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return OVRSessionStatus.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return OVRSessionStatus.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static boolean nIsVisible(long struct) {
        return MemoryUtil.memGetByte((long)(struct + (long)ISVISIBLE)) != 0;
    }

    public static boolean nHmdPresent(long struct) {
        return MemoryUtil.memGetByte((long)(struct + (long)HMDPRESENT)) != 0;
    }

    public static boolean nHmdMounted(long struct) {
        return MemoryUtil.memGetByte((long)(struct + (long)HMDMOUNTED)) != 0;
    }

    public static boolean nDisplayLost(long struct) {
        return MemoryUtil.memGetByte((long)(struct + (long)DISPLAYLOST)) != 0;
    }

    public static boolean nShouldQuit(long struct) {
        return MemoryUtil.memGetByte((long)(struct + (long)SHOULDQUIT)) != 0;
    }

    public static boolean nShouldRecenter(long struct) {
        return MemoryUtil.memGetByte((long)(struct + (long)SHOULDRECENTER)) != 0;
    }

    public static ByteBuffer nInternal(long struct) {
        return MemoryUtil.memByteBuffer((long)(struct + (long)INTERNAL), (int)2);
    }

    public static boolean nInternal(long struct, int index) {
        if (Checks.CHECKS) {
            Checks.check((int)index, (int)2);
        }
        return MemoryUtil.memGetByte((long)(struct + (long)INTERNAL + (long)(index * 1))) != 0;
    }

    static {
        Struct.Layout layout = OVRSessionStatus.__struct((Struct.Member[])new Struct.Member[]{OVRSessionStatus.__member((int)1), OVRSessionStatus.__member((int)1), OVRSessionStatus.__member((int)1), OVRSessionStatus.__member((int)1), OVRSessionStatus.__member((int)1), OVRSessionStatus.__member((int)1), OVRSessionStatus.__array((int)1, (int)2)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        ISVISIBLE = layout.offsetof(0);
        HMDPRESENT = layout.offsetof(1);
        HMDMOUNTED = layout.offsetof(2);
        DISPLAYLOST = layout.offsetof(3);
        SHOULDQUIT = layout.offsetof(4);
        SHOULDRECENTER = layout.offsetof(5);
        INTERNAL = layout.offsetof(6);
    }

    public static class Buffer
    extends StructBuffer<OVRSessionStatus, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        Buffer(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer newBufferInstance(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        protected OVRSessionStatus newInstance(long address) {
            return new OVRSessionStatus(address, this.container);
        }

        public int sizeof() {
            return SIZEOF;
        }

        @NativeType(value="ovrBool")
        public boolean IsVisible() {
            return OVRSessionStatus.nIsVisible(this.address());
        }

        @NativeType(value="ovrBool")
        public boolean HmdPresent() {
            return OVRSessionStatus.nHmdPresent(this.address());
        }

        @NativeType(value="ovrBool")
        public boolean HmdMounted() {
            return OVRSessionStatus.nHmdMounted(this.address());
        }

        @NativeType(value="ovrBool")
        public boolean DisplayLost() {
            return OVRSessionStatus.nDisplayLost(this.address());
        }

        @NativeType(value="ovrBool")
        public boolean ShouldQuit() {
            return OVRSessionStatus.nShouldQuit(this.address());
        }

        @NativeType(value="ovrBool")
        public boolean ShouldRecenter() {
            return OVRSessionStatus.nShouldRecenter(this.address());
        }

        @NativeType(value="ovrBool[2]")
        public ByteBuffer Internal() {
            return OVRSessionStatus.nInternal(this.address());
        }

        @NativeType(value="ovrBool")
        public boolean Internal(int index) {
            return OVRSessionStatus.nInternal(this.address(), index);
        }
    }
}

