/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.ovr;

import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct ovrQuatf")
public class OVRQuatf
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int X;
    public static final int Y;
    public static final int Z;
    public static final int W;

    OVRQuatf(long address, ByteBuffer container) {
        super(address, container);
    }

    public OVRQuatf(ByteBuffer container) {
        this(MemoryUtil.memAddress((ByteBuffer)container), OVRQuatf.checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    public float x() {
        return OVRQuatf.nx(this.address());
    }

    public float y() {
        return OVRQuatf.ny(this.address());
    }

    public float z() {
        return OVRQuatf.nz(this.address());
    }

    public float w() {
        return OVRQuatf.nw(this.address());
    }

    public OVRQuatf x(float value) {
        OVRQuatf.nx(this.address(), value);
        return this;
    }

    public OVRQuatf y(float value) {
        OVRQuatf.ny(this.address(), value);
        return this;
    }

    public OVRQuatf z(float value) {
        OVRQuatf.nz(this.address(), value);
        return this;
    }

    public OVRQuatf w(float value) {
        OVRQuatf.nw(this.address(), value);
        return this;
    }

    public OVRQuatf set(float x, float y, float z, float w) {
        this.x(x);
        this.y(y);
        this.z(z);
        this.w(w);
        return this;
    }

    public OVRQuatf set(OVRQuatf src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static OVRQuatf malloc() {
        return OVRQuatf.create(MemoryUtil.nmemAlloc((long)SIZEOF));
    }

    public static OVRQuatf calloc() {
        return OVRQuatf.create(MemoryUtil.nmemCalloc((long)1L, (long)SIZEOF));
    }

    public static OVRQuatf create() {
        return new OVRQuatf(BufferUtils.createByteBuffer((int)SIZEOF));
    }

    public static OVRQuatf create(long address) {
        return address == 0L ? null : new OVRQuatf(address, null);
    }

    public static Buffer malloc(int capacity) {
        return OVRQuatf.create(OVRQuatf.__malloc((int)capacity, (int)SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return OVRQuatf.create(MemoryUtil.nmemCalloc((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(OVRQuatf.__create((int)capacity, (int)SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, null, -1, 0, capacity, capacity);
    }

    public static OVRQuatf mallocStack() {
        return OVRQuatf.mallocStack(MemoryStack.stackGet());
    }

    public static OVRQuatf callocStack() {
        return OVRQuatf.callocStack(MemoryStack.stackGet());
    }

    public static OVRQuatf mallocStack(MemoryStack stack) {
        return OVRQuatf.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static OVRQuatf callocStack(MemoryStack stack) {
        return OVRQuatf.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return OVRQuatf.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return OVRQuatf.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return OVRQuatf.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return OVRQuatf.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static float nx(long struct) {
        return MemoryUtil.memGetFloat((long)(struct + (long)X));
    }

    public static float ny(long struct) {
        return MemoryUtil.memGetFloat((long)(struct + (long)Y));
    }

    public static float nz(long struct) {
        return MemoryUtil.memGetFloat((long)(struct + (long)Z));
    }

    public static float nw(long struct) {
        return MemoryUtil.memGetFloat((long)(struct + (long)W));
    }

    public static void nx(long struct, float value) {
        MemoryUtil.memPutFloat((long)(struct + (long)X), (float)value);
    }

    public static void ny(long struct, float value) {
        MemoryUtil.memPutFloat((long)(struct + (long)Y), (float)value);
    }

    public static void nz(long struct, float value) {
        MemoryUtil.memPutFloat((long)(struct + (long)Z), (float)value);
    }

    public static void nw(long struct, float value) {
        MemoryUtil.memPutFloat((long)(struct + (long)W), (float)value);
    }

    static {
        Struct.Layout layout = OVRQuatf.__struct((Struct.Member[])new Struct.Member[]{OVRQuatf.__member((int)4), OVRQuatf.__member((int)4), OVRQuatf.__member((int)4), OVRQuatf.__member((int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        X = layout.offsetof(0);
        Y = layout.offsetof(1);
        Z = layout.offsetof(2);
        W = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<OVRQuatf, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        Buffer(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer newBufferInstance(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        protected OVRQuatf newInstance(long address) {
            return new OVRQuatf(address, this.container);
        }

        public int sizeof() {
            return SIZEOF;
        }

        public float x() {
            return OVRQuatf.nx(this.address());
        }

        public float y() {
            return OVRQuatf.ny(this.address());
        }

        public float z() {
            return OVRQuatf.nz(this.address());
        }

        public float w() {
            return OVRQuatf.nw(this.address());
        }

        public Buffer x(float value) {
            OVRQuatf.nx(this.address(), value);
            return this;
        }

        public Buffer y(float value) {
            OVRQuatf.ny(this.address(), value);
            return this;
        }

        public Buffer z(float value) {
            OVRQuatf.nz(this.address(), value);
            return this;
        }

        public Buffer w(float value) {
            OVRQuatf.nw(this.address(), value);
            return this;
        }
    }
}

