/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.ovr;

import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.ovr.OVRPosef;
import org.lwjgl.ovr.OVRVector3f;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct ovrPoseStatef")
public class OVRPoseStatef
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int THEPOSE;
    public static final int ANGULARVELOCITY;
    public static final int LINEARVELOCITY;
    public static final int ANGULARACCELERATION;
    public static final int LINEARACCELERATION;
    public static final int TIMEINSECONDS;

    OVRPoseStatef(long address, ByteBuffer container) {
        super(address, container);
    }

    public OVRPoseStatef(ByteBuffer container) {
        this(MemoryUtil.memAddress((ByteBuffer)container), OVRPoseStatef.checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="ovrPosef")
    public OVRPosef ThePose() {
        return OVRPoseStatef.nThePose(this.address());
    }

    @NativeType(value="ovrVector3f")
    public OVRVector3f AngularVelocity() {
        return OVRPoseStatef.nAngularVelocity(this.address());
    }

    @NativeType(value="ovrVector3f")
    public OVRVector3f LinearVelocity() {
        return OVRPoseStatef.nLinearVelocity(this.address());
    }

    @NativeType(value="ovrVector3f")
    public OVRVector3f AngularAcceleration() {
        return OVRPoseStatef.nAngularAcceleration(this.address());
    }

    @NativeType(value="ovrVector3f")
    public OVRVector3f LinearAcceleration() {
        return OVRPoseStatef.nLinearAcceleration(this.address());
    }

    public double TimeInSeconds() {
        return OVRPoseStatef.nTimeInSeconds(this.address());
    }

    public static OVRPoseStatef malloc() {
        return OVRPoseStatef.create(MemoryUtil.nmemAlloc((long)SIZEOF));
    }

    public static OVRPoseStatef calloc() {
        return OVRPoseStatef.create(MemoryUtil.nmemCalloc((long)1L, (long)SIZEOF));
    }

    public static OVRPoseStatef create() {
        return new OVRPoseStatef(BufferUtils.createByteBuffer((int)SIZEOF));
    }

    public static OVRPoseStatef create(long address) {
        return address == 0L ? null : new OVRPoseStatef(address, null);
    }

    public static Buffer malloc(int capacity) {
        return OVRPoseStatef.create(OVRPoseStatef.__malloc((int)capacity, (int)SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return OVRPoseStatef.create(MemoryUtil.nmemCalloc((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(OVRPoseStatef.__create((int)capacity, (int)SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, null, -1, 0, capacity, capacity);
    }

    public static OVRPoseStatef mallocStack() {
        return OVRPoseStatef.mallocStack(MemoryStack.stackGet());
    }

    public static OVRPoseStatef callocStack() {
        return OVRPoseStatef.callocStack(MemoryStack.stackGet());
    }

    public static OVRPoseStatef mallocStack(MemoryStack stack) {
        return OVRPoseStatef.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static OVRPoseStatef callocStack(MemoryStack stack) {
        return OVRPoseStatef.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return OVRPoseStatef.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return OVRPoseStatef.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return OVRPoseStatef.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return OVRPoseStatef.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static OVRPosef nThePose(long struct) {
        return OVRPosef.create(struct + (long)THEPOSE);
    }

    public static OVRVector3f nAngularVelocity(long struct) {
        return OVRVector3f.create(struct + (long)ANGULARVELOCITY);
    }

    public static OVRVector3f nLinearVelocity(long struct) {
        return OVRVector3f.create(struct + (long)LINEARVELOCITY);
    }

    public static OVRVector3f nAngularAcceleration(long struct) {
        return OVRVector3f.create(struct + (long)ANGULARACCELERATION);
    }

    public static OVRVector3f nLinearAcceleration(long struct) {
        return OVRVector3f.create(struct + (long)LINEARACCELERATION);
    }

    public static double nTimeInSeconds(long struct) {
        return MemoryUtil.memGetDouble((long)(struct + (long)TIMEINSECONDS));
    }

    static {
        Struct.Layout layout = OVRPoseStatef.__struct((Struct.Member[])new Struct.Member[]{OVRPoseStatef.__member((int)OVRPosef.SIZEOF, (int)OVRPosef.ALIGNOF), OVRPoseStatef.__member((int)OVRVector3f.SIZEOF, (int)OVRVector3f.ALIGNOF), OVRPoseStatef.__member((int)OVRVector3f.SIZEOF, (int)OVRVector3f.ALIGNOF), OVRPoseStatef.__member((int)OVRVector3f.SIZEOF, (int)OVRVector3f.ALIGNOF), OVRPoseStatef.__member((int)OVRVector3f.SIZEOF, (int)OVRVector3f.ALIGNOF), OVRPoseStatef.__padding((int)4, (boolean)true), OVRPoseStatef.__member((int)8)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        THEPOSE = layout.offsetof(0);
        ANGULARVELOCITY = layout.offsetof(1);
        LINEARVELOCITY = layout.offsetof(2);
        ANGULARACCELERATION = layout.offsetof(3);
        LINEARACCELERATION = layout.offsetof(4);
        TIMEINSECONDS = layout.offsetof(6);
    }

    public static class Buffer
    extends StructBuffer<OVRPoseStatef, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        Buffer(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer newBufferInstance(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        protected OVRPoseStatef newInstance(long address) {
            return new OVRPoseStatef(address, this.container);
        }

        public int sizeof() {
            return SIZEOF;
        }

        @NativeType(value="ovrPosef")
        public OVRPosef ThePose() {
            return OVRPoseStatef.nThePose(this.address());
        }

        @NativeType(value="ovrVector3f")
        public OVRVector3f AngularVelocity() {
            return OVRPoseStatef.nAngularVelocity(this.address());
        }

        @NativeType(value="ovrVector3f")
        public OVRVector3f LinearVelocity() {
            return OVRPoseStatef.nLinearVelocity(this.address());
        }

        @NativeType(value="ovrVector3f")
        public OVRVector3f AngularAcceleration() {
            return OVRPoseStatef.nAngularAcceleration(this.address());
        }

        @NativeType(value="ovrVector3f")
        public OVRVector3f LinearAcceleration() {
            return OVRPoseStatef.nLinearAcceleration(this.address());
        }

        public double TimeInSeconds() {
            return OVRPoseStatef.nTimeInSeconds(this.address());
        }
    }
}

