/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.ovr;

import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.ovr.OVRLayerHeader;
import org.lwjgl.ovr.OVRPosef;
import org.lwjgl.ovr.OVRRecti;
import org.lwjgl.ovr.OVRVector2f;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct ovrLayerQuad")
public class OVRLayerQuad
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int HEADER;
    public static final int COLORTEXTURE;
    public static final int VIEWPORT;
    public static final int QUADPOSECENTER;
    public static final int QUADSIZE;

    OVRLayerQuad(long address, ByteBuffer container) {
        super(address, container);
    }

    public OVRLayerQuad(ByteBuffer container) {
        this(MemoryUtil.memAddress((ByteBuffer)container), OVRLayerQuad.checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="ovrLayerHeader")
    public OVRLayerHeader Header() {
        return OVRLayerQuad.nHeader(this.address());
    }

    @NativeType(value="ovrTextureSwapChain")
    public long ColorTexture() {
        return OVRLayerQuad.nColorTexture(this.address());
    }

    @NativeType(value="ovrRecti")
    public OVRRecti Viewport() {
        return OVRLayerQuad.nViewport(this.address());
    }

    @NativeType(value="ovrPosef")
    public OVRPosef QuadPoseCenter() {
        return OVRLayerQuad.nQuadPoseCenter(this.address());
    }

    @NativeType(value="ovrVector2f")
    public OVRVector2f QuadSize() {
        return OVRLayerQuad.nQuadSize(this.address());
    }

    public OVRLayerQuad Header(@NativeType(value="ovrLayerHeader") OVRLayerHeader value) {
        OVRLayerQuad.nHeader(this.address(), value);
        return this;
    }

    public OVRLayerQuad ColorTexture(@NativeType(value="ovrTextureSwapChain") long value) {
        OVRLayerQuad.nColorTexture(this.address(), value);
        return this;
    }

    public OVRLayerQuad Viewport(@NativeType(value="ovrRecti") OVRRecti value) {
        OVRLayerQuad.nViewport(this.address(), value);
        return this;
    }

    public OVRLayerQuad QuadPoseCenter(@NativeType(value="ovrPosef") OVRPosef value) {
        OVRLayerQuad.nQuadPoseCenter(this.address(), value);
        return this;
    }

    public OVRLayerQuad QuadSize(@NativeType(value="ovrVector2f") OVRVector2f value) {
        OVRLayerQuad.nQuadSize(this.address(), value);
        return this;
    }

    public OVRLayerQuad set(OVRLayerHeader Header, long ColorTexture, OVRRecti Viewport, OVRPosef QuadPoseCenter, OVRVector2f QuadSize) {
        this.Header(Header);
        this.ColorTexture(ColorTexture);
        this.Viewport(Viewport);
        this.QuadPoseCenter(QuadPoseCenter);
        this.QuadSize(QuadSize);
        return this;
    }

    public OVRLayerQuad set(OVRLayerQuad src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static OVRLayerQuad malloc() {
        return OVRLayerQuad.create(MemoryUtil.nmemAlloc((long)SIZEOF));
    }

    public static OVRLayerQuad calloc() {
        return OVRLayerQuad.create(MemoryUtil.nmemCalloc((long)1L, (long)SIZEOF));
    }

    public static OVRLayerQuad create() {
        return new OVRLayerQuad(BufferUtils.createByteBuffer((int)SIZEOF));
    }

    public static OVRLayerQuad create(long address) {
        return address == 0L ? null : new OVRLayerQuad(address, null);
    }

    public static Buffer malloc(int capacity) {
        return OVRLayerQuad.create(OVRLayerQuad.__malloc((int)capacity, (int)SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return OVRLayerQuad.create(MemoryUtil.nmemCalloc((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(OVRLayerQuad.__create((int)capacity, (int)SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, null, -1, 0, capacity, capacity);
    }

    public static OVRLayerQuad mallocStack() {
        return OVRLayerQuad.mallocStack(MemoryStack.stackGet());
    }

    public static OVRLayerQuad callocStack() {
        return OVRLayerQuad.callocStack(MemoryStack.stackGet());
    }

    public static OVRLayerQuad mallocStack(MemoryStack stack) {
        return OVRLayerQuad.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static OVRLayerQuad callocStack(MemoryStack stack) {
        return OVRLayerQuad.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return OVRLayerQuad.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return OVRLayerQuad.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return OVRLayerQuad.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return OVRLayerQuad.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static OVRLayerHeader nHeader(long struct) {
        return OVRLayerHeader.create(struct + (long)HEADER);
    }

    public static long nColorTexture(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)COLORTEXTURE));
    }

    public static OVRRecti nViewport(long struct) {
        return OVRRecti.create(struct + (long)VIEWPORT);
    }

    public static OVRPosef nQuadPoseCenter(long struct) {
        return OVRPosef.create(struct + (long)QUADPOSECENTER);
    }

    public static OVRVector2f nQuadSize(long struct) {
        return OVRVector2f.create(struct + (long)QUADSIZE);
    }

    public static void nHeader(long struct, OVRLayerHeader value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)HEADER), (long)OVRLayerHeader.SIZEOF);
    }

    public static void nColorTexture(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)COLORTEXTURE), (long)Checks.check((long)value));
    }

    public static void nViewport(long struct, OVRRecti value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)VIEWPORT), (long)OVRRecti.SIZEOF);
    }

    public static void nQuadPoseCenter(long struct, OVRPosef value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)QUADPOSECENTER), (long)OVRPosef.SIZEOF);
    }

    public static void nQuadSize(long struct, OVRVector2f value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)QUADSIZE), (long)OVRVector2f.SIZEOF);
    }

    public static void validate(long struct) {
        Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)COLORTEXTURE)));
    }

    public static void validate(long array, int count) {
        for (int i = 0; i < count; ++i) {
            OVRLayerQuad.validate(array + (long)(i * SIZEOF));
        }
    }

    static {
        Struct.Layout layout = OVRLayerQuad.__struct((Struct.Member[])new Struct.Member[]{OVRLayerQuad.__member((int)OVRLayerHeader.SIZEOF, (int)OVRLayerHeader.ALIGNOF), OVRLayerQuad.__member((int)POINTER_SIZE), OVRLayerQuad.__member((int)OVRRecti.SIZEOF, (int)OVRRecti.ALIGNOF), OVRLayerQuad.__member((int)OVRPosef.SIZEOF, (int)OVRPosef.ALIGNOF), OVRLayerQuad.__member((int)OVRVector2f.SIZEOF, (int)OVRVector2f.ALIGNOF)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        HEADER = layout.offsetof(0);
        COLORTEXTURE = layout.offsetof(1);
        VIEWPORT = layout.offsetof(2);
        QUADPOSECENTER = layout.offsetof(3);
        QUADSIZE = layout.offsetof(4);
    }

    public static class Buffer
    extends StructBuffer<OVRLayerQuad, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        Buffer(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer newBufferInstance(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        protected OVRLayerQuad newInstance(long address) {
            return new OVRLayerQuad(address, this.container);
        }

        public int sizeof() {
            return SIZEOF;
        }

        @NativeType(value="ovrLayerHeader")
        public OVRLayerHeader Header() {
            return OVRLayerQuad.nHeader(this.address());
        }

        @NativeType(value="ovrTextureSwapChain")
        public long ColorTexture() {
            return OVRLayerQuad.nColorTexture(this.address());
        }

        @NativeType(value="ovrRecti")
        public OVRRecti Viewport() {
            return OVRLayerQuad.nViewport(this.address());
        }

        @NativeType(value="ovrPosef")
        public OVRPosef QuadPoseCenter() {
            return OVRLayerQuad.nQuadPoseCenter(this.address());
        }

        @NativeType(value="ovrVector2f")
        public OVRVector2f QuadSize() {
            return OVRLayerQuad.nQuadSize(this.address());
        }

        public Buffer Header(@NativeType(value="ovrLayerHeader") OVRLayerHeader value) {
            OVRLayerQuad.nHeader(this.address(), value);
            return this;
        }

        public Buffer ColorTexture(@NativeType(value="ovrTextureSwapChain") long value) {
            OVRLayerQuad.nColorTexture(this.address(), value);
            return this;
        }

        public Buffer Viewport(@NativeType(value="ovrRecti") OVRRecti value) {
            OVRLayerQuad.nViewport(this.address(), value);
            return this;
        }

        public Buffer QuadPoseCenter(@NativeType(value="ovrPosef") OVRPosef value) {
            OVRLayerQuad.nQuadPoseCenter(this.address(), value);
            return this;
        }

        public Buffer QuadSize(@NativeType(value="ovrVector2f") OVRVector2f value) {
            OVRLayerQuad.nQuadSize(this.address(), value);
            return this;
        }
    }
}

