/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.ovr;

import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct ovrLayerHeader")
public class OVRLayerHeader
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int FLAGS;

    OVRLayerHeader(long address, ByteBuffer container) {
        super(address, container);
    }

    public OVRLayerHeader(ByteBuffer container) {
        this(MemoryUtil.memAddress((ByteBuffer)container), OVRLayerHeader.checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="ovrLayerType")
    public int Type() {
        return OVRLayerHeader.nType(this.address());
    }

    @NativeType(value="unsigned int")
    public int Flags() {
        return OVRLayerHeader.nFlags(this.address());
    }

    public OVRLayerHeader Type(@NativeType(value="ovrLayerType") int value) {
        OVRLayerHeader.nType(this.address(), value);
        return this;
    }

    public OVRLayerHeader Flags(@NativeType(value="unsigned int") int value) {
        OVRLayerHeader.nFlags(this.address(), value);
        return this;
    }

    public OVRLayerHeader set(int Type, int Flags) {
        this.Type(Type);
        this.Flags(Flags);
        return this;
    }

    public OVRLayerHeader set(OVRLayerHeader src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static OVRLayerHeader malloc() {
        return OVRLayerHeader.create(MemoryUtil.nmemAlloc((long)SIZEOF));
    }

    public static OVRLayerHeader calloc() {
        return OVRLayerHeader.create(MemoryUtil.nmemCalloc((long)1L, (long)SIZEOF));
    }

    public static OVRLayerHeader create() {
        return new OVRLayerHeader(BufferUtils.createByteBuffer((int)SIZEOF));
    }

    public static OVRLayerHeader create(long address) {
        return address == 0L ? null : new OVRLayerHeader(address, null);
    }

    public static Buffer malloc(int capacity) {
        return OVRLayerHeader.create(OVRLayerHeader.__malloc((int)capacity, (int)SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return OVRLayerHeader.create(MemoryUtil.nmemCalloc((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(OVRLayerHeader.__create((int)capacity, (int)SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, null, -1, 0, capacity, capacity);
    }

    public static OVRLayerHeader mallocStack() {
        return OVRLayerHeader.mallocStack(MemoryStack.stackGet());
    }

    public static OVRLayerHeader callocStack() {
        return OVRLayerHeader.callocStack(MemoryStack.stackGet());
    }

    public static OVRLayerHeader mallocStack(MemoryStack stack) {
        return OVRLayerHeader.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static OVRLayerHeader callocStack(MemoryStack stack) {
        return OVRLayerHeader.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return OVRLayerHeader.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return OVRLayerHeader.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return OVRLayerHeader.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return OVRLayerHeader.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nType(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)TYPE));
    }

    public static int nFlags(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)FLAGS));
    }

    public static void nType(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)TYPE), (int)value);
    }

    public static void nFlags(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)FLAGS), (int)value);
    }

    static {
        Struct.Layout layout = OVRLayerHeader.__struct((Struct.Member[])new Struct.Member[]{OVRLayerHeader.__member((int)4), OVRLayerHeader.__member((int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        FLAGS = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<OVRLayerHeader, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        Buffer(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer newBufferInstance(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        protected OVRLayerHeader newInstance(long address) {
            return new OVRLayerHeader(address, this.container);
        }

        public int sizeof() {
            return SIZEOF;
        }

        @NativeType(value="ovrLayerType")
        public int Type() {
            return OVRLayerHeader.nType(this.address());
        }

        @NativeType(value="unsigned int")
        public int Flags() {
            return OVRLayerHeader.nFlags(this.address());
        }

        public Buffer Type(@NativeType(value="ovrLayerType") int value) {
            OVRLayerHeader.nType(this.address(), value);
            return this;
        }

        public Buffer Flags(@NativeType(value="unsigned int") int value) {
            OVRLayerHeader.nFlags(this.address(), value);
            return this;
        }
    }
}

