/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.ovr;

import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.ovr.OVRLogCallback;
import org.lwjgl.ovr.OVRLogCallbackI;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Pointer;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct ovrInitParams")
public class OVRInitParams
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int FLAGS;
    public static final int REQUESTEDMINORVERSION;
    public static final int LOGCALLBACK;
    public static final int USERDATA;
    public static final int CONNECTIONTIMEOUTMS;

    OVRInitParams(long address, ByteBuffer container) {
        super(address, container);
    }

    public OVRInitParams(ByteBuffer container) {
        this(MemoryUtil.memAddress((ByteBuffer)container), OVRInitParams.checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="uint32_t")
    public int Flags() {
        return OVRInitParams.nFlags(this.address());
    }

    @NativeType(value="uint32_t")
    public int RequestedMinorVersion() {
        return OVRInitParams.nRequestedMinorVersion(this.address());
    }

    @NativeType(value="ovrLogCallback")
    public OVRLogCallback LogCallback() {
        return OVRInitParams.nLogCallback(this.address());
    }

    @NativeType(value="uintptr_t")
    public long UserData() {
        return OVRInitParams.nUserData(this.address());
    }

    @NativeType(value="uint32_t")
    public int ConnectionTimeoutMS() {
        return OVRInitParams.nConnectionTimeoutMS(this.address());
    }

    public OVRInitParams Flags(@NativeType(value="uint32_t") int value) {
        OVRInitParams.nFlags(this.address(), value);
        return this;
    }

    public OVRInitParams RequestedMinorVersion(@NativeType(value="uint32_t") int value) {
        OVRInitParams.nRequestedMinorVersion(this.address(), value);
        return this;
    }

    public OVRInitParams LogCallback(@NativeType(value="ovrLogCallback") OVRLogCallbackI value) {
        OVRInitParams.nLogCallback(this.address(), value);
        return this;
    }

    public OVRInitParams UserData(@NativeType(value="uintptr_t") long value) {
        OVRInitParams.nUserData(this.address(), value);
        return this;
    }

    public OVRInitParams ConnectionTimeoutMS(@NativeType(value="uint32_t") int value) {
        OVRInitParams.nConnectionTimeoutMS(this.address(), value);
        return this;
    }

    public OVRInitParams set(int Flags, int RequestedMinorVersion, OVRLogCallbackI LogCallback, long UserData, int ConnectionTimeoutMS) {
        this.Flags(Flags);
        this.RequestedMinorVersion(RequestedMinorVersion);
        this.LogCallback(LogCallback);
        this.UserData(UserData);
        this.ConnectionTimeoutMS(ConnectionTimeoutMS);
        return this;
    }

    public OVRInitParams set(OVRInitParams src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static OVRInitParams malloc() {
        return OVRInitParams.create(MemoryUtil.nmemAlloc((long)SIZEOF));
    }

    public static OVRInitParams calloc() {
        return OVRInitParams.create(MemoryUtil.nmemCalloc((long)1L, (long)SIZEOF));
    }

    public static OVRInitParams create() {
        return new OVRInitParams(BufferUtils.createByteBuffer((int)SIZEOF));
    }

    public static OVRInitParams create(long address) {
        return address == 0L ? null : new OVRInitParams(address, null);
    }

    public static Buffer malloc(int capacity) {
        return OVRInitParams.create(OVRInitParams.__malloc((int)capacity, (int)SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return OVRInitParams.create(MemoryUtil.nmemCalloc((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(OVRInitParams.__create((int)capacity, (int)SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, null, -1, 0, capacity, capacity);
    }

    public static OVRInitParams mallocStack() {
        return OVRInitParams.mallocStack(MemoryStack.stackGet());
    }

    public static OVRInitParams callocStack() {
        return OVRInitParams.callocStack(MemoryStack.stackGet());
    }

    public static OVRInitParams mallocStack(MemoryStack stack) {
        return OVRInitParams.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static OVRInitParams callocStack(MemoryStack stack) {
        return OVRInitParams.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return OVRInitParams.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return OVRInitParams.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return OVRInitParams.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return OVRInitParams.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nFlags(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)FLAGS));
    }

    public static int nRequestedMinorVersion(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)REQUESTEDMINORVERSION));
    }

    public static OVRLogCallback nLogCallback(long struct) {
        return OVRLogCallback.create(MemoryUtil.memGetAddress((long)(struct + (long)LOGCALLBACK)));
    }

    public static long nUserData(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)USERDATA));
    }

    public static int nConnectionTimeoutMS(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)CONNECTIONTIMEOUTMS));
    }

    public static void nFlags(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)FLAGS), (int)value);
    }

    public static void nRequestedMinorVersion(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)REQUESTEDMINORVERSION), (int)value);
    }

    public static void nLogCallback(long struct, OVRLogCallbackI value) {
        MemoryUtil.memPutAddress((long)(struct + (long)LOGCALLBACK), (long)MemoryUtil.memAddressSafe((Pointer)value));
    }

    public static void nUserData(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)USERDATA), (long)value);
    }

    public static void nConnectionTimeoutMS(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)CONNECTIONTIMEOUTMS), (int)value);
    }

    static {
        Struct.Layout layout = OVRInitParams.__struct((Struct.Member[])new Struct.Member[]{OVRInitParams.__member((int)4), OVRInitParams.__member((int)4), OVRInitParams.__member((int)POINTER_SIZE), OVRInitParams.__member((int)POINTER_SIZE), OVRInitParams.__member((int)4), OVRInitParams.__padding((int)4, (boolean)Pointer.BITS64)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        FLAGS = layout.offsetof(0);
        REQUESTEDMINORVERSION = layout.offsetof(1);
        LOGCALLBACK = layout.offsetof(2);
        USERDATA = layout.offsetof(3);
        CONNECTIONTIMEOUTMS = layout.offsetof(4);
    }

    public static class Buffer
    extends StructBuffer<OVRInitParams, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        Buffer(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer newBufferInstance(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        protected OVRInitParams newInstance(long address) {
            return new OVRInitParams(address, this.container);
        }

        public int sizeof() {
            return SIZEOF;
        }

        @NativeType(value="uint32_t")
        public int Flags() {
            return OVRInitParams.nFlags(this.address());
        }

        @NativeType(value="uint32_t")
        public int RequestedMinorVersion() {
            return OVRInitParams.nRequestedMinorVersion(this.address());
        }

        @NativeType(value="ovrLogCallback")
        public OVRLogCallback LogCallback() {
            return OVRInitParams.nLogCallback(this.address());
        }

        @NativeType(value="uintptr_t")
        public long UserData() {
            return OVRInitParams.nUserData(this.address());
        }

        @NativeType(value="uint32_t")
        public int ConnectionTimeoutMS() {
            return OVRInitParams.nConnectionTimeoutMS(this.address());
        }

        public Buffer Flags(@NativeType(value="uint32_t") int value) {
            OVRInitParams.nFlags(this.address(), value);
            return this;
        }

        public Buffer RequestedMinorVersion(@NativeType(value="uint32_t") int value) {
            OVRInitParams.nRequestedMinorVersion(this.address(), value);
            return this;
        }

        public Buffer LogCallback(@NativeType(value="ovrLogCallback") OVRLogCallbackI value) {
            OVRInitParams.nLogCallback(this.address(), value);
            return this;
        }

        public Buffer UserData(@NativeType(value="uintptr_t") long value) {
            OVRInitParams.nUserData(this.address(), value);
            return this;
        }

        public Buffer ConnectionTimeoutMS(@NativeType(value="uint32_t") int value) {
            OVRInitParams.nConnectionTimeoutMS(this.address(), value);
            return this;
        }
    }
}

