/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.ovr;

import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.ovr.OVRFovPort;
import org.lwjgl.ovr.OVRSizei;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Pointer;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct ovrHmdDesc")
public class OVRHmdDesc
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int PRODUCTNAME;
    public static final int MANUFACTURER;
    public static final int VENDORID;
    public static final int PRODUCTID;
    public static final int SERIALNUMBER;
    public static final int FIRMWAREMAJOR;
    public static final int FIRMWAREMINOR;
    public static final int AVAILABLEHMDCAPS;
    public static final int DEFAULTHMDCAPS;
    public static final int AVAILABLETRACKINGCAPS;
    public static final int DEFAULTTRACKINGCAPS;
    public static final int DEFAULTEYEFOV;
    public static final int MAXEYEFOV;
    public static final int RESOLUTION;
    public static final int DISPLAYREFRESHRATE;

    OVRHmdDesc(long address, ByteBuffer container) {
        super(address, container);
    }

    public OVRHmdDesc(ByteBuffer container) {
        this(MemoryUtil.memAddress((ByteBuffer)container), OVRHmdDesc.checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="ovrHmdType")
    public int Type() {
        return OVRHmdDesc.nType(this.address());
    }

    @NativeType(value="char[64]")
    public ByteBuffer ProductName() {
        return OVRHmdDesc.nProductName(this.address());
    }

    @NativeType(value="char[64]")
    public String ProductNameString() {
        return OVRHmdDesc.nProductNameString(this.address());
    }

    @NativeType(value="char[64]")
    public ByteBuffer Manufacturer() {
        return OVRHmdDesc.nManufacturer(this.address());
    }

    @NativeType(value="char[64]")
    public String ManufacturerString() {
        return OVRHmdDesc.nManufacturerString(this.address());
    }

    public short VendorId() {
        return OVRHmdDesc.nVendorId(this.address());
    }

    public short ProductId() {
        return OVRHmdDesc.nProductId(this.address());
    }

    @NativeType(value="char[24]")
    public ByteBuffer SerialNumber() {
        return OVRHmdDesc.nSerialNumber(this.address());
    }

    @NativeType(value="char[24]")
    public String SerialNumberString() {
        return OVRHmdDesc.nSerialNumberString(this.address());
    }

    public short FirmwareMajor() {
        return OVRHmdDesc.nFirmwareMajor(this.address());
    }

    public short FirmwareMinor() {
        return OVRHmdDesc.nFirmwareMinor(this.address());
    }

    @NativeType(value="unsigned int")
    public int AvailableHmdCaps() {
        return OVRHmdDesc.nAvailableHmdCaps(this.address());
    }

    @NativeType(value="unsigned int")
    public int DefaultHmdCaps() {
        return OVRHmdDesc.nDefaultHmdCaps(this.address());
    }

    @NativeType(value="unsigned int")
    public int AvailableTrackingCaps() {
        return OVRHmdDesc.nAvailableTrackingCaps(this.address());
    }

    @NativeType(value="unsigned int")
    public int DefaultTrackingCaps() {
        return OVRHmdDesc.nDefaultTrackingCaps(this.address());
    }

    @NativeType(value="ovrFovPort[ovrEye_Count]")
    public OVRFovPort.Buffer DefaultEyeFov() {
        return OVRHmdDesc.nDefaultEyeFov(this.address());
    }

    @NativeType(value="ovrFovPort")
    public OVRFovPort DefaultEyeFov(int index) {
        return OVRHmdDesc.nDefaultEyeFov(this.address(), index);
    }

    @NativeType(value="ovrFovPort[ovrEye_Count]")
    public OVRFovPort.Buffer MaxEyeFov() {
        return OVRHmdDesc.nMaxEyeFov(this.address());
    }

    @NativeType(value="ovrFovPort")
    public OVRFovPort MaxEyeFov(int index) {
        return OVRHmdDesc.nMaxEyeFov(this.address(), index);
    }

    @NativeType(value="ovrSizei")
    public OVRSizei Resolution() {
        return OVRHmdDesc.nResolution(this.address());
    }

    public float DisplayRefreshRate() {
        return OVRHmdDesc.nDisplayRefreshRate(this.address());
    }

    public static OVRHmdDesc malloc() {
        return OVRHmdDesc.create(MemoryUtil.nmemAlloc((long)SIZEOF));
    }

    public static OVRHmdDesc calloc() {
        return OVRHmdDesc.create(MemoryUtil.nmemCalloc((long)1L, (long)SIZEOF));
    }

    public static OVRHmdDesc create() {
        return new OVRHmdDesc(BufferUtils.createByteBuffer((int)SIZEOF));
    }

    public static OVRHmdDesc create(long address) {
        return address == 0L ? null : new OVRHmdDesc(address, null);
    }

    public static Buffer malloc(int capacity) {
        return OVRHmdDesc.create(OVRHmdDesc.__malloc((int)capacity, (int)SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return OVRHmdDesc.create(MemoryUtil.nmemCalloc((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(OVRHmdDesc.__create((int)capacity, (int)SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, null, -1, 0, capacity, capacity);
    }

    public static OVRHmdDesc mallocStack() {
        return OVRHmdDesc.mallocStack(MemoryStack.stackGet());
    }

    public static OVRHmdDesc callocStack() {
        return OVRHmdDesc.callocStack(MemoryStack.stackGet());
    }

    public static OVRHmdDesc mallocStack(MemoryStack stack) {
        return OVRHmdDesc.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static OVRHmdDesc callocStack(MemoryStack stack) {
        return OVRHmdDesc.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return OVRHmdDesc.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return OVRHmdDesc.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return OVRHmdDesc.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return OVRHmdDesc.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nType(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)TYPE));
    }

    public static ByteBuffer nProductName(long struct) {
        return MemoryUtil.memByteBuffer((long)(struct + (long)PRODUCTNAME), (int)64);
    }

    public static String nProductNameString(long struct) {
        return MemoryUtil.memUTF8((long)(struct + (long)PRODUCTNAME));
    }

    public static ByteBuffer nManufacturer(long struct) {
        return MemoryUtil.memByteBuffer((long)(struct + (long)MANUFACTURER), (int)64);
    }

    public static String nManufacturerString(long struct) {
        return MemoryUtil.memUTF8((long)(struct + (long)MANUFACTURER));
    }

    public static short nVendorId(long struct) {
        return MemoryUtil.memGetShort((long)(struct + (long)VENDORID));
    }

    public static short nProductId(long struct) {
        return MemoryUtil.memGetShort((long)(struct + (long)PRODUCTID));
    }

    public static ByteBuffer nSerialNumber(long struct) {
        return MemoryUtil.memByteBuffer((long)(struct + (long)SERIALNUMBER), (int)24);
    }

    public static String nSerialNumberString(long struct) {
        return MemoryUtil.memASCII((long)(struct + (long)SERIALNUMBER));
    }

    public static short nFirmwareMajor(long struct) {
        return MemoryUtil.memGetShort((long)(struct + (long)FIRMWAREMAJOR));
    }

    public static short nFirmwareMinor(long struct) {
        return MemoryUtil.memGetShort((long)(struct + (long)FIRMWAREMINOR));
    }

    public static int nAvailableHmdCaps(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)AVAILABLEHMDCAPS));
    }

    public static int nDefaultHmdCaps(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)DEFAULTHMDCAPS));
    }

    public static int nAvailableTrackingCaps(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)AVAILABLETRACKINGCAPS));
    }

    public static int nDefaultTrackingCaps(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)DEFAULTTRACKINGCAPS));
    }

    public static OVRFovPort.Buffer nDefaultEyeFov(long struct) {
        return OVRFovPort.create(struct + (long)DEFAULTEYEFOV, 2);
    }

    public static OVRFovPort nDefaultEyeFov(long struct, int index) {
        if (Checks.CHECKS) {
            Checks.check((int)index, (int)2);
        }
        return OVRFovPort.create(struct + (long)DEFAULTEYEFOV + (long)(index * OVRFovPort.SIZEOF));
    }

    public static OVRFovPort.Buffer nMaxEyeFov(long struct) {
        return OVRFovPort.create(struct + (long)MAXEYEFOV, 2);
    }

    public static OVRFovPort nMaxEyeFov(long struct, int index) {
        if (Checks.CHECKS) {
            Checks.check((int)index, (int)2);
        }
        return OVRFovPort.create(struct + (long)MAXEYEFOV + (long)(index * OVRFovPort.SIZEOF));
    }

    public static OVRSizei nResolution(long struct) {
        return OVRSizei.create(struct + (long)RESOLUTION);
    }

    public static float nDisplayRefreshRate(long struct) {
        return MemoryUtil.memGetFloat((long)(struct + (long)DISPLAYREFRESHRATE));
    }

    static {
        Struct.Layout layout = OVRHmdDesc.__struct((Struct.Member[])new Struct.Member[]{OVRHmdDesc.__member((int)4), OVRHmdDesc.__padding((int)4, (boolean)Pointer.BITS64), OVRHmdDesc.__array((int)1, (int)64), OVRHmdDesc.__array((int)1, (int)64), OVRHmdDesc.__member((int)2), OVRHmdDesc.__member((int)2), OVRHmdDesc.__array((int)1, (int)24), OVRHmdDesc.__member((int)2), OVRHmdDesc.__member((int)2), OVRHmdDesc.__member((int)4), OVRHmdDesc.__member((int)4), OVRHmdDesc.__member((int)4), OVRHmdDesc.__member((int)4), OVRHmdDesc.__array((int)OVRFovPort.SIZEOF, (int)OVRFovPort.ALIGNOF, (int)2), OVRHmdDesc.__array((int)OVRFovPort.SIZEOF, (int)OVRFovPort.ALIGNOF, (int)2), OVRHmdDesc.__member((int)OVRSizei.SIZEOF, (int)OVRSizei.ALIGNOF), OVRHmdDesc.__member((int)4), OVRHmdDesc.__padding((int)4, (boolean)Pointer.BITS64)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        PRODUCTNAME = layout.offsetof(2);
        MANUFACTURER = layout.offsetof(3);
        VENDORID = layout.offsetof(4);
        PRODUCTID = layout.offsetof(5);
        SERIALNUMBER = layout.offsetof(6);
        FIRMWAREMAJOR = layout.offsetof(7);
        FIRMWAREMINOR = layout.offsetof(8);
        AVAILABLEHMDCAPS = layout.offsetof(9);
        DEFAULTHMDCAPS = layout.offsetof(10);
        AVAILABLETRACKINGCAPS = layout.offsetof(11);
        DEFAULTTRACKINGCAPS = layout.offsetof(12);
        DEFAULTEYEFOV = layout.offsetof(13);
        MAXEYEFOV = layout.offsetof(14);
        RESOLUTION = layout.offsetof(15);
        DISPLAYREFRESHRATE = layout.offsetof(16);
    }

    public static class Buffer
    extends StructBuffer<OVRHmdDesc, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        Buffer(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer newBufferInstance(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        protected OVRHmdDesc newInstance(long address) {
            return new OVRHmdDesc(address, this.container);
        }

        public int sizeof() {
            return SIZEOF;
        }

        @NativeType(value="ovrHmdType")
        public int Type() {
            return OVRHmdDesc.nType(this.address());
        }

        @NativeType(value="char[64]")
        public ByteBuffer ProductName() {
            return OVRHmdDesc.nProductName(this.address());
        }

        @NativeType(value="char[64]")
        public String ProductNameString() {
            return OVRHmdDesc.nProductNameString(this.address());
        }

        @NativeType(value="char[64]")
        public ByteBuffer Manufacturer() {
            return OVRHmdDesc.nManufacturer(this.address());
        }

        @NativeType(value="char[64]")
        public String ManufacturerString() {
            return OVRHmdDesc.nManufacturerString(this.address());
        }

        public short VendorId() {
            return OVRHmdDesc.nVendorId(this.address());
        }

        public short ProductId() {
            return OVRHmdDesc.nProductId(this.address());
        }

        @NativeType(value="char[24]")
        public ByteBuffer SerialNumber() {
            return OVRHmdDesc.nSerialNumber(this.address());
        }

        @NativeType(value="char[24]")
        public String SerialNumberString() {
            return OVRHmdDesc.nSerialNumberString(this.address());
        }

        public short FirmwareMajor() {
            return OVRHmdDesc.nFirmwareMajor(this.address());
        }

        public short FirmwareMinor() {
            return OVRHmdDesc.nFirmwareMinor(this.address());
        }

        @NativeType(value="unsigned int")
        public int AvailableHmdCaps() {
            return OVRHmdDesc.nAvailableHmdCaps(this.address());
        }

        @NativeType(value="unsigned int")
        public int DefaultHmdCaps() {
            return OVRHmdDesc.nDefaultHmdCaps(this.address());
        }

        @NativeType(value="unsigned int")
        public int AvailableTrackingCaps() {
            return OVRHmdDesc.nAvailableTrackingCaps(this.address());
        }

        @NativeType(value="unsigned int")
        public int DefaultTrackingCaps() {
            return OVRHmdDesc.nDefaultTrackingCaps(this.address());
        }

        @NativeType(value="ovrFovPort[ovrEye_Count]")
        public OVRFovPort.Buffer DefaultEyeFov() {
            return OVRHmdDesc.nDefaultEyeFov(this.address());
        }

        @NativeType(value="ovrFovPort")
        public OVRFovPort DefaultEyeFov(int index) {
            return OVRHmdDesc.nDefaultEyeFov(this.address(), index);
        }

        @NativeType(value="ovrFovPort[ovrEye_Count]")
        public OVRFovPort.Buffer MaxEyeFov() {
            return OVRHmdDesc.nMaxEyeFov(this.address());
        }

        @NativeType(value="ovrFovPort")
        public OVRFovPort MaxEyeFov(int index) {
            return OVRHmdDesc.nMaxEyeFov(this.address(), index);
        }

        @NativeType(value="ovrSizei")
        public OVRSizei Resolution() {
            return OVRHmdDesc.nResolution(this.address());
        }

        public float DisplayRefreshRate() {
            return OVRHmdDesc.nDisplayRefreshRate(this.address());
        }
    }
}

