/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.ovr;

import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct ovrHapticsClip")
public class OVRHapticsClip
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int SAMPLES;
    public static final int SAMPLESCOUNT;

    OVRHapticsClip(long address, ByteBuffer container) {
        super(address, container);
    }

    public OVRHapticsClip(ByteBuffer container) {
        this(MemoryUtil.memAddress((ByteBuffer)container), OVRHapticsClip.checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="const void *")
    public ByteBuffer Samples(int capacity) {
        return OVRHapticsClip.nSamples(this.address(), capacity);
    }

    public int SamplesCount() {
        return OVRHapticsClip.nSamplesCount(this.address());
    }

    public static OVRHapticsClip malloc() {
        return OVRHapticsClip.create(MemoryUtil.nmemAlloc((long)SIZEOF));
    }

    public static OVRHapticsClip calloc() {
        return OVRHapticsClip.create(MemoryUtil.nmemCalloc((long)1L, (long)SIZEOF));
    }

    public static OVRHapticsClip create() {
        return new OVRHapticsClip(BufferUtils.createByteBuffer((int)SIZEOF));
    }

    public static OVRHapticsClip create(long address) {
        return address == 0L ? null : new OVRHapticsClip(address, null);
    }

    public static Buffer malloc(int capacity) {
        return OVRHapticsClip.create(OVRHapticsClip.__malloc((int)capacity, (int)SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return OVRHapticsClip.create(MemoryUtil.nmemCalloc((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(OVRHapticsClip.__create((int)capacity, (int)SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, null, -1, 0, capacity, capacity);
    }

    public static OVRHapticsClip mallocStack() {
        return OVRHapticsClip.mallocStack(MemoryStack.stackGet());
    }

    public static OVRHapticsClip callocStack() {
        return OVRHapticsClip.callocStack(MemoryStack.stackGet());
    }

    public static OVRHapticsClip mallocStack(MemoryStack stack) {
        return OVRHapticsClip.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static OVRHapticsClip callocStack(MemoryStack stack) {
        return OVRHapticsClip.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return OVRHapticsClip.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return OVRHapticsClip.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return OVRHapticsClip.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return OVRHapticsClip.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static ByteBuffer nSamples(long struct, int capacity) {
        return MemoryUtil.memByteBuffer((long)MemoryUtil.memGetAddress((long)(struct + (long)SAMPLES)), (int)capacity);
    }

    public static int nSamplesCount(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)SAMPLESCOUNT));
    }

    static {
        Struct.Layout layout = OVRHapticsClip.__struct((Struct.Member[])new Struct.Member[]{OVRHapticsClip.__member((int)POINTER_SIZE), OVRHapticsClip.__member((int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        SAMPLES = layout.offsetof(0);
        SAMPLESCOUNT = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<OVRHapticsClip, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        Buffer(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer newBufferInstance(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        protected OVRHapticsClip newInstance(long address) {
            return new OVRHapticsClip(address, this.container);
        }

        public int sizeof() {
            return SIZEOF;
        }

        @NativeType(value="const void *")
        public ByteBuffer Samples(int capacity) {
            return OVRHapticsClip.nSamples(this.address(), capacity);
        }

        public int SamplesCount() {
            return OVRHapticsClip.nSamplesCount(this.address());
        }
    }
}

