/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.ovr;

import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct ovrHapticsBuffer")
public class OVRHapticsBuffer
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int SAMPLES;
    public static final int SAMPLESCOUNT;
    public static final int SUBMITMODE;

    OVRHapticsBuffer(long address, ByteBuffer container) {
        super(address, container);
    }

    public OVRHapticsBuffer(ByteBuffer container) {
        this(MemoryUtil.memAddress((ByteBuffer)container), OVRHapticsBuffer.checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="void *")
    public ByteBuffer Samples(int capacity) {
        return OVRHapticsBuffer.nSamples(this.address(), capacity);
    }

    public int SamplesCount() {
        return OVRHapticsBuffer.nSamplesCount(this.address());
    }

    @NativeType(value="ovrHapticsBufferSubmitMode")
    public int SubmitMode() {
        return OVRHapticsBuffer.nSubmitMode(this.address());
    }

    public OVRHapticsBuffer Samples(@NativeType(value="void *") ByteBuffer value) {
        OVRHapticsBuffer.nSamples(this.address(), value);
        return this;
    }

    public OVRHapticsBuffer SamplesCount(int value) {
        OVRHapticsBuffer.nSamplesCount(this.address(), value);
        return this;
    }

    public OVRHapticsBuffer SubmitMode(@NativeType(value="ovrHapticsBufferSubmitMode") int value) {
        OVRHapticsBuffer.nSubmitMode(this.address(), value);
        return this;
    }

    public OVRHapticsBuffer set(ByteBuffer Samples, int SamplesCount, int SubmitMode) {
        this.Samples(Samples);
        this.SamplesCount(SamplesCount);
        this.SubmitMode(SubmitMode);
        return this;
    }

    public OVRHapticsBuffer set(OVRHapticsBuffer src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static OVRHapticsBuffer malloc() {
        return OVRHapticsBuffer.create(MemoryUtil.nmemAlloc((long)SIZEOF));
    }

    public static OVRHapticsBuffer calloc() {
        return OVRHapticsBuffer.create(MemoryUtil.nmemCalloc((long)1L, (long)SIZEOF));
    }

    public static OVRHapticsBuffer create() {
        return new OVRHapticsBuffer(BufferUtils.createByteBuffer((int)SIZEOF));
    }

    public static OVRHapticsBuffer create(long address) {
        return address == 0L ? null : new OVRHapticsBuffer(address, null);
    }

    public static Buffer malloc(int capacity) {
        return OVRHapticsBuffer.create(OVRHapticsBuffer.__malloc((int)capacity, (int)SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return OVRHapticsBuffer.create(MemoryUtil.nmemCalloc((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(OVRHapticsBuffer.__create((int)capacity, (int)SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, null, -1, 0, capacity, capacity);
    }

    public static OVRHapticsBuffer mallocStack() {
        return OVRHapticsBuffer.mallocStack(MemoryStack.stackGet());
    }

    public static OVRHapticsBuffer callocStack() {
        return OVRHapticsBuffer.callocStack(MemoryStack.stackGet());
    }

    public static OVRHapticsBuffer mallocStack(MemoryStack stack) {
        return OVRHapticsBuffer.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static OVRHapticsBuffer callocStack(MemoryStack stack) {
        return OVRHapticsBuffer.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return OVRHapticsBuffer.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return OVRHapticsBuffer.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return OVRHapticsBuffer.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return OVRHapticsBuffer.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static ByteBuffer nSamples(long struct, int capacity) {
        return MemoryUtil.memByteBuffer((long)MemoryUtil.memGetAddress((long)(struct + (long)SAMPLES)), (int)capacity);
    }

    public static int nSamplesCount(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)SAMPLESCOUNT));
    }

    public static int nSubmitMode(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)SUBMITMODE));
    }

    public static void nSamples(long struct, ByteBuffer value) {
        MemoryUtil.memPutAddress((long)(struct + (long)SAMPLES), (long)MemoryUtil.memAddress((ByteBuffer)value));
    }

    public static void nSamplesCount(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)SAMPLESCOUNT), (int)value);
    }

    public static void nSubmitMode(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)SUBMITMODE), (int)value);
    }

    public static void validate(long struct) {
        Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)SAMPLES)));
    }

    public static void validate(long array, int count) {
        for (int i = 0; i < count; ++i) {
            OVRHapticsBuffer.validate(array + (long)(i * SIZEOF));
        }
    }

    static {
        Struct.Layout layout = OVRHapticsBuffer.__struct((Struct.Member[])new Struct.Member[]{OVRHapticsBuffer.__member((int)POINTER_SIZE), OVRHapticsBuffer.__member((int)4), OVRHapticsBuffer.__member((int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        SAMPLES = layout.offsetof(0);
        SAMPLESCOUNT = layout.offsetof(1);
        SUBMITMODE = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<OVRHapticsBuffer, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        Buffer(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer newBufferInstance(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        protected OVRHapticsBuffer newInstance(long address) {
            return new OVRHapticsBuffer(address, this.container);
        }

        public int sizeof() {
            return SIZEOF;
        }

        @NativeType(value="void *")
        public ByteBuffer Samples(int capacity) {
            return OVRHapticsBuffer.nSamples(this.address(), capacity);
        }

        public int SamplesCount() {
            return OVRHapticsBuffer.nSamplesCount(this.address());
        }

        @NativeType(value="ovrHapticsBufferSubmitMode")
        public int SubmitMode() {
            return OVRHapticsBuffer.nSubmitMode(this.address());
        }

        public Buffer Samples(@NativeType(value="void *") ByteBuffer value) {
            OVRHapticsBuffer.nSamples(this.address(), value);
            return this;
        }

        public Buffer SamplesCount(int value) {
            OVRHapticsBuffer.nSamplesCount(this.address(), value);
            return this;
        }

        public Buffer SubmitMode(@NativeType(value="ovrHapticsBufferSubmitMode") int value) {
            OVRHapticsBuffer.nSubmitMode(this.address(), value);
            return this;
        }
    }
}

