/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.ovr;

import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.ovr.OVRCameraExtrinsics;
import org.lwjgl.ovr.OVRCameraIntrinsics;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct ovrExternalCamera")
public class OVRExternalCamera
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int NAME;
    public static final int INTRINSICS;
    public static final int EXTRINSICS;

    OVRExternalCamera(long address, ByteBuffer container) {
        super(address, container);
    }

    public OVRExternalCamera(ByteBuffer container) {
        this(MemoryUtil.memAddress((ByteBuffer)container), OVRExternalCamera.checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="char[32]")
    public ByteBuffer Name() {
        return OVRExternalCamera.nName(this.address());
    }

    @NativeType(value="char[32]")
    public String NameString() {
        return OVRExternalCamera.nNameString(this.address());
    }

    @NativeType(value="ovrCameraIntrinsics")
    public OVRCameraIntrinsics Intrinsics() {
        return OVRExternalCamera.nIntrinsics(this.address());
    }

    @NativeType(value="ovrCameraExtrinsics")
    public OVRCameraExtrinsics Extrinsics() {
        return OVRExternalCamera.nExtrinsics(this.address());
    }

    public static OVRExternalCamera malloc() {
        return OVRExternalCamera.create(MemoryUtil.nmemAlloc((long)SIZEOF));
    }

    public static OVRExternalCamera calloc() {
        return OVRExternalCamera.create(MemoryUtil.nmemCalloc((long)1L, (long)SIZEOF));
    }

    public static OVRExternalCamera create() {
        return new OVRExternalCamera(BufferUtils.createByteBuffer((int)SIZEOF));
    }

    public static OVRExternalCamera create(long address) {
        return address == 0L ? null : new OVRExternalCamera(address, null);
    }

    public static Buffer malloc(int capacity) {
        return OVRExternalCamera.create(OVRExternalCamera.__malloc((int)capacity, (int)SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return OVRExternalCamera.create(MemoryUtil.nmemCalloc((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(OVRExternalCamera.__create((int)capacity, (int)SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, null, -1, 0, capacity, capacity);
    }

    public static OVRExternalCamera mallocStack() {
        return OVRExternalCamera.mallocStack(MemoryStack.stackGet());
    }

    public static OVRExternalCamera callocStack() {
        return OVRExternalCamera.callocStack(MemoryStack.stackGet());
    }

    public static OVRExternalCamera mallocStack(MemoryStack stack) {
        return OVRExternalCamera.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static OVRExternalCamera callocStack(MemoryStack stack) {
        return OVRExternalCamera.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return OVRExternalCamera.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return OVRExternalCamera.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return OVRExternalCamera.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return OVRExternalCamera.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static ByteBuffer nName(long struct) {
        return MemoryUtil.memByteBuffer((long)(struct + (long)NAME), (int)32);
    }

    public static String nNameString(long struct) {
        return MemoryUtil.memASCII((long)(struct + (long)NAME));
    }

    public static OVRCameraIntrinsics nIntrinsics(long struct) {
        return OVRCameraIntrinsics.create(struct + (long)INTRINSICS);
    }

    public static OVRCameraExtrinsics nExtrinsics(long struct) {
        return OVRCameraExtrinsics.create(struct + (long)EXTRINSICS);
    }

    static {
        Struct.Layout layout = OVRExternalCamera.__struct((Struct.Member[])new Struct.Member[]{OVRExternalCamera.__array((int)1, (int)32), OVRExternalCamera.__member((int)OVRCameraIntrinsics.SIZEOF, (int)OVRCameraIntrinsics.ALIGNOF), OVRExternalCamera.__member((int)OVRCameraExtrinsics.SIZEOF, (int)OVRCameraExtrinsics.ALIGNOF)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        NAME = layout.offsetof(0);
        INTRINSICS = layout.offsetof(1);
        EXTRINSICS = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<OVRExternalCamera, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        Buffer(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer newBufferInstance(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        protected OVRExternalCamera newInstance(long address) {
            return new OVRExternalCamera(address, this.container);
        }

        public int sizeof() {
            return SIZEOF;
        }

        @NativeType(value="char[32]")
        public ByteBuffer Name() {
            return OVRExternalCamera.nName(this.address());
        }

        @NativeType(value="char[32]")
        public String NameString() {
            return OVRExternalCamera.nNameString(this.address());
        }

        @NativeType(value="ovrCameraIntrinsics")
        public OVRCameraIntrinsics Intrinsics() {
            return OVRExternalCamera.nIntrinsics(this.address());
        }

        @NativeType(value="ovrCameraExtrinsics")
        public OVRCameraExtrinsics Extrinsics() {
            return OVRExternalCamera.nExtrinsics(this.address());
        }
    }
}

