/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.ovr;

import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct ovrColorf")
public class OVRColorf
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int R;
    public static final int G;
    public static final int B;
    public static final int A;

    OVRColorf(long address, ByteBuffer container) {
        super(address, container);
    }

    public OVRColorf(ByteBuffer container) {
        this(MemoryUtil.memAddress((ByteBuffer)container), OVRColorf.checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    public float r() {
        return OVRColorf.nr(this.address());
    }

    public float g() {
        return OVRColorf.ng(this.address());
    }

    public float b() {
        return OVRColorf.nb(this.address());
    }

    public float a() {
        return OVRColorf.na(this.address());
    }

    public OVRColorf r(float value) {
        OVRColorf.nr(this.address(), value);
        return this;
    }

    public OVRColorf g(float value) {
        OVRColorf.ng(this.address(), value);
        return this;
    }

    public OVRColorf b(float value) {
        OVRColorf.nb(this.address(), value);
        return this;
    }

    public OVRColorf a(float value) {
        OVRColorf.na(this.address(), value);
        return this;
    }

    public OVRColorf set(float r, float g, float b, float a) {
        this.r(r);
        this.g(g);
        this.b(b);
        this.a(a);
        return this;
    }

    public OVRColorf set(OVRColorf src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static OVRColorf malloc() {
        return OVRColorf.create(MemoryUtil.nmemAlloc((long)SIZEOF));
    }

    public static OVRColorf calloc() {
        return OVRColorf.create(MemoryUtil.nmemCalloc((long)1L, (long)SIZEOF));
    }

    public static OVRColorf create() {
        return new OVRColorf(BufferUtils.createByteBuffer((int)SIZEOF));
    }

    public static OVRColorf create(long address) {
        return address == 0L ? null : new OVRColorf(address, null);
    }

    public static Buffer malloc(int capacity) {
        return OVRColorf.create(OVRColorf.__malloc((int)capacity, (int)SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return OVRColorf.create(MemoryUtil.nmemCalloc((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(OVRColorf.__create((int)capacity, (int)SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, null, -1, 0, capacity, capacity);
    }

    public static OVRColorf mallocStack() {
        return OVRColorf.mallocStack(MemoryStack.stackGet());
    }

    public static OVRColorf callocStack() {
        return OVRColorf.callocStack(MemoryStack.stackGet());
    }

    public static OVRColorf mallocStack(MemoryStack stack) {
        return OVRColorf.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static OVRColorf callocStack(MemoryStack stack) {
        return OVRColorf.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return OVRColorf.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return OVRColorf.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return OVRColorf.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return OVRColorf.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static float nr(long struct) {
        return MemoryUtil.memGetFloat((long)(struct + (long)R));
    }

    public static float ng(long struct) {
        return MemoryUtil.memGetFloat((long)(struct + (long)G));
    }

    public static float nb(long struct) {
        return MemoryUtil.memGetFloat((long)(struct + (long)B));
    }

    public static float na(long struct) {
        return MemoryUtil.memGetFloat((long)(struct + (long)A));
    }

    public static void nr(long struct, float value) {
        MemoryUtil.memPutFloat((long)(struct + (long)R), (float)value);
    }

    public static void ng(long struct, float value) {
        MemoryUtil.memPutFloat((long)(struct + (long)G), (float)value);
    }

    public static void nb(long struct, float value) {
        MemoryUtil.memPutFloat((long)(struct + (long)B), (float)value);
    }

    public static void na(long struct, float value) {
        MemoryUtil.memPutFloat((long)(struct + (long)A), (float)value);
    }

    static {
        Struct.Layout layout = OVRColorf.__struct((Struct.Member[])new Struct.Member[]{OVRColorf.__member((int)4), OVRColorf.__member((int)4), OVRColorf.__member((int)4), OVRColorf.__member((int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        R = layout.offsetof(0);
        G = layout.offsetof(1);
        B = layout.offsetof(2);
        A = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<OVRColorf, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        Buffer(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer newBufferInstance(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        protected OVRColorf newInstance(long address) {
            return new OVRColorf(address, this.container);
        }

        public int sizeof() {
            return SIZEOF;
        }

        public float r() {
            return OVRColorf.nr(this.address());
        }

        public float g() {
            return OVRColorf.ng(this.address());
        }

        public float b() {
            return OVRColorf.nb(this.address());
        }

        public float a() {
            return OVRColorf.na(this.address());
        }

        public Buffer r(float value) {
            OVRColorf.nr(this.address(), value);
            return this;
        }

        public Buffer g(float value) {
            OVRColorf.ng(this.address(), value);
            return this;
        }

        public Buffer b(float value) {
            OVRColorf.nb(this.address(), value);
            return this;
        }

        public Buffer a(float value) {
            OVRColorf.na(this.address(), value);
            return this;
        }
    }
}

