/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.ovr;

import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.ovr.OVRPosef;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct ovrCameraExtrinsics")
public class OVRCameraExtrinsics
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int LASTCHANGEDTIMESECONDS;
    public static final int CAMERASTATUSFLAGS;
    public static final int ATTACHEDTODEVICE;
    public static final int RELATIVEPOSE;
    public static final int LASTEXPOSURETIMESECONDS;
    public static final int EXPOSURELATENCYSECONDS;
    public static final int ADDITIONALLATENCYSECONDS;

    OVRCameraExtrinsics(long address, ByteBuffer container) {
        super(address, container);
    }

    public OVRCameraExtrinsics(ByteBuffer container) {
        this(MemoryUtil.memAddress((ByteBuffer)container), OVRCameraExtrinsics.checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    public double LastChangedTimeSeconds() {
        return OVRCameraExtrinsics.nLastChangedTimeSeconds(this.address());
    }

    @NativeType(value="unsigned int")
    public int CameraStatusFlags() {
        return OVRCameraExtrinsics.nCameraStatusFlags(this.address());
    }

    @NativeType(value="ovrTrackedDeviceType")
    public int AttachedToDevice() {
        return OVRCameraExtrinsics.nAttachedToDevice(this.address());
    }

    @NativeType(value="ovrPosef")
    public OVRPosef RelativePose() {
        return OVRCameraExtrinsics.nRelativePose(this.address());
    }

    public double LastExposureTimeSeconds() {
        return OVRCameraExtrinsics.nLastExposureTimeSeconds(this.address());
    }

    public double ExposureLatencySeconds() {
        return OVRCameraExtrinsics.nExposureLatencySeconds(this.address());
    }

    public double AdditionalLatencySeconds() {
        return OVRCameraExtrinsics.nAdditionalLatencySeconds(this.address());
    }

    public OVRCameraExtrinsics LastChangedTimeSeconds(double value) {
        OVRCameraExtrinsics.nLastChangedTimeSeconds(this.address(), value);
        return this;
    }

    public OVRCameraExtrinsics CameraStatusFlags(@NativeType(value="unsigned int") int value) {
        OVRCameraExtrinsics.nCameraStatusFlags(this.address(), value);
        return this;
    }

    public OVRCameraExtrinsics AttachedToDevice(@NativeType(value="ovrTrackedDeviceType") int value) {
        OVRCameraExtrinsics.nAttachedToDevice(this.address(), value);
        return this;
    }

    public OVRCameraExtrinsics RelativePose(@NativeType(value="ovrPosef") OVRPosef value) {
        OVRCameraExtrinsics.nRelativePose(this.address(), value);
        return this;
    }

    public OVRCameraExtrinsics LastExposureTimeSeconds(double value) {
        OVRCameraExtrinsics.nLastExposureTimeSeconds(this.address(), value);
        return this;
    }

    public OVRCameraExtrinsics ExposureLatencySeconds(double value) {
        OVRCameraExtrinsics.nExposureLatencySeconds(this.address(), value);
        return this;
    }

    public OVRCameraExtrinsics AdditionalLatencySeconds(double value) {
        OVRCameraExtrinsics.nAdditionalLatencySeconds(this.address(), value);
        return this;
    }

    public OVRCameraExtrinsics set(double LastChangedTimeSeconds, int CameraStatusFlags, int AttachedToDevice, OVRPosef RelativePose, double LastExposureTimeSeconds, double ExposureLatencySeconds, double AdditionalLatencySeconds) {
        this.LastChangedTimeSeconds(LastChangedTimeSeconds);
        this.CameraStatusFlags(CameraStatusFlags);
        this.AttachedToDevice(AttachedToDevice);
        this.RelativePose(RelativePose);
        this.LastExposureTimeSeconds(LastExposureTimeSeconds);
        this.ExposureLatencySeconds(ExposureLatencySeconds);
        this.AdditionalLatencySeconds(AdditionalLatencySeconds);
        return this;
    }

    public OVRCameraExtrinsics set(OVRCameraExtrinsics src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static OVRCameraExtrinsics malloc() {
        return OVRCameraExtrinsics.create(MemoryUtil.nmemAlloc((long)SIZEOF));
    }

    public static OVRCameraExtrinsics calloc() {
        return OVRCameraExtrinsics.create(MemoryUtil.nmemCalloc((long)1L, (long)SIZEOF));
    }

    public static OVRCameraExtrinsics create() {
        return new OVRCameraExtrinsics(BufferUtils.createByteBuffer((int)SIZEOF));
    }

    public static OVRCameraExtrinsics create(long address) {
        return address == 0L ? null : new OVRCameraExtrinsics(address, null);
    }

    public static Buffer malloc(int capacity) {
        return OVRCameraExtrinsics.create(OVRCameraExtrinsics.__malloc((int)capacity, (int)SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return OVRCameraExtrinsics.create(MemoryUtil.nmemCalloc((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(OVRCameraExtrinsics.__create((int)capacity, (int)SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, null, -1, 0, capacity, capacity);
    }

    public static OVRCameraExtrinsics mallocStack() {
        return OVRCameraExtrinsics.mallocStack(MemoryStack.stackGet());
    }

    public static OVRCameraExtrinsics callocStack() {
        return OVRCameraExtrinsics.callocStack(MemoryStack.stackGet());
    }

    public static OVRCameraExtrinsics mallocStack(MemoryStack stack) {
        return OVRCameraExtrinsics.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static OVRCameraExtrinsics callocStack(MemoryStack stack) {
        return OVRCameraExtrinsics.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return OVRCameraExtrinsics.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return OVRCameraExtrinsics.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return OVRCameraExtrinsics.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return OVRCameraExtrinsics.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static double nLastChangedTimeSeconds(long struct) {
        return MemoryUtil.memGetDouble((long)(struct + (long)LASTCHANGEDTIMESECONDS));
    }

    public static int nCameraStatusFlags(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)CAMERASTATUSFLAGS));
    }

    public static int nAttachedToDevice(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)ATTACHEDTODEVICE));
    }

    public static OVRPosef nRelativePose(long struct) {
        return OVRPosef.create(struct + (long)RELATIVEPOSE);
    }

    public static double nLastExposureTimeSeconds(long struct) {
        return MemoryUtil.memGetDouble((long)(struct + (long)LASTEXPOSURETIMESECONDS));
    }

    public static double nExposureLatencySeconds(long struct) {
        return MemoryUtil.memGetDouble((long)(struct + (long)EXPOSURELATENCYSECONDS));
    }

    public static double nAdditionalLatencySeconds(long struct) {
        return MemoryUtil.memGetDouble((long)(struct + (long)ADDITIONALLATENCYSECONDS));
    }

    public static void nLastChangedTimeSeconds(long struct, double value) {
        MemoryUtil.memPutDouble((long)(struct + (long)LASTCHANGEDTIMESECONDS), (double)value);
    }

    public static void nCameraStatusFlags(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)CAMERASTATUSFLAGS), (int)value);
    }

    public static void nAttachedToDevice(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)ATTACHEDTODEVICE), (int)value);
    }

    public static void nRelativePose(long struct, OVRPosef value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)RELATIVEPOSE), (long)OVRPosef.SIZEOF);
    }

    public static void nLastExposureTimeSeconds(long struct, double value) {
        MemoryUtil.memPutDouble((long)(struct + (long)LASTEXPOSURETIMESECONDS), (double)value);
    }

    public static void nExposureLatencySeconds(long struct, double value) {
        MemoryUtil.memPutDouble((long)(struct + (long)EXPOSURELATENCYSECONDS), (double)value);
    }

    public static void nAdditionalLatencySeconds(long struct, double value) {
        MemoryUtil.memPutDouble((long)(struct + (long)ADDITIONALLATENCYSECONDS), (double)value);
    }

    static {
        Struct.Layout layout = OVRCameraExtrinsics.__struct((Struct.Member[])new Struct.Member[]{OVRCameraExtrinsics.__member((int)8), OVRCameraExtrinsics.__member((int)4), OVRCameraExtrinsics.__member((int)4), OVRCameraExtrinsics.__member((int)OVRPosef.SIZEOF, (int)OVRPosef.ALIGNOF), OVRCameraExtrinsics.__member((int)8), OVRCameraExtrinsics.__member((int)8), OVRCameraExtrinsics.__member((int)8)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        LASTCHANGEDTIMESECONDS = layout.offsetof(0);
        CAMERASTATUSFLAGS = layout.offsetof(1);
        ATTACHEDTODEVICE = layout.offsetof(2);
        RELATIVEPOSE = layout.offsetof(3);
        LASTEXPOSURETIMESECONDS = layout.offsetof(4);
        EXPOSURELATENCYSECONDS = layout.offsetof(5);
        ADDITIONALLATENCYSECONDS = layout.offsetof(6);
    }

    public static class Buffer
    extends StructBuffer<OVRCameraExtrinsics, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        Buffer(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer newBufferInstance(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        protected OVRCameraExtrinsics newInstance(long address) {
            return new OVRCameraExtrinsics(address, this.container);
        }

        public int sizeof() {
            return SIZEOF;
        }

        public double LastChangedTimeSeconds() {
            return OVRCameraExtrinsics.nLastChangedTimeSeconds(this.address());
        }

        @NativeType(value="unsigned int")
        public int CameraStatusFlags() {
            return OVRCameraExtrinsics.nCameraStatusFlags(this.address());
        }

        @NativeType(value="ovrTrackedDeviceType")
        public int AttachedToDevice() {
            return OVRCameraExtrinsics.nAttachedToDevice(this.address());
        }

        @NativeType(value="ovrPosef")
        public OVRPosef RelativePose() {
            return OVRCameraExtrinsics.nRelativePose(this.address());
        }

        public double LastExposureTimeSeconds() {
            return OVRCameraExtrinsics.nLastExposureTimeSeconds(this.address());
        }

        public double ExposureLatencySeconds() {
            return OVRCameraExtrinsics.nExposureLatencySeconds(this.address());
        }

        public double AdditionalLatencySeconds() {
            return OVRCameraExtrinsics.nAdditionalLatencySeconds(this.address());
        }

        public Buffer LastChangedTimeSeconds(double value) {
            OVRCameraExtrinsics.nLastChangedTimeSeconds(this.address(), value);
            return this;
        }

        public Buffer CameraStatusFlags(@NativeType(value="unsigned int") int value) {
            OVRCameraExtrinsics.nCameraStatusFlags(this.address(), value);
            return this;
        }

        public Buffer AttachedToDevice(@NativeType(value="ovrTrackedDeviceType") int value) {
            OVRCameraExtrinsics.nAttachedToDevice(this.address(), value);
            return this;
        }

        public Buffer RelativePose(@NativeType(value="ovrPosef") OVRPosef value) {
            OVRCameraExtrinsics.nRelativePose(this.address(), value);
            return this;
        }

        public Buffer LastExposureTimeSeconds(double value) {
            OVRCameraExtrinsics.nLastExposureTimeSeconds(this.address(), value);
            return this;
        }

        public Buffer ExposureLatencySeconds(double value) {
            OVRCameraExtrinsics.nExposureLatencySeconds(this.address(), value);
            return this;
        }

        public Buffer AdditionalLatencySeconds(double value) {
            OVRCameraExtrinsics.nAdditionalLatencySeconds(this.address(), value);
            return this;
        }
    }
}

