/*
 * Copyright LWJGL. All rights reserved.
 * License terms: https://www.lwjgl.org/license
 * MACHINE GENERATED FILE, DO NOT EDIT
 */
package org.lwjgl.ovr;

import java.nio.*;

import org.lwjgl.*;
import org.lwjgl.system.*;

import static org.lwjgl.system.Checks.*;
import static org.lwjgl.system.MemoryUtil.*;
import static org.lwjgl.system.MemoryStack.*;

import static org.lwjgl.ovr.OVR.ovrEye_Count;

/**
 * Contains the data necessary to properly calculate position info for various layer types.
 * 
 * <ul>
 * <li>{@code HmdToEyePose} is the same value-pair provided in {@link OVREyeRenderDesc}. Modifying this value is suggested only if the app is forcing monoscopic
 * rendering and requires that all layers including quad layers show up in a monoscopic fashion.</li>
 * <li>{@code HmdSpaceToWorldScaleInMeters} is used to scale player motion into in-application units.</li>
 * </ul>
 * 
 * <p>In other words, it is how big an in-application unit is in the player's physical meters. For example, if the application uses inches as its units then
 * {@code HmdSpaceToWorldScaleInMeters} would be 0.0254. Note that if you are scaling the player in size, this must also scale. So if your application
 * units are inches, but you're shrinking the player to half their normal size, then {@code HmdSpaceToWorldScaleInMeters} would be {@code 0.0254*2.0}.</p>
 * 
 * <h3>Member documentation</h3>
 * 
 * <ul>
 * <li>{@code HmdToEyePose} &ndash; transform of each eye from the HMD center, in meters</li>
 * <li>{@code HmdSpaceToWorldScaleInMeters} &ndash; ratio of viewer units to meter units</li>
 * </ul>
 * 
 * <h3>Layout</h3>
 * 
 * <code><pre>
 * struct ovrViewScaleDesc {
 *     {@link OVRPosef ovrPosef} HmdToEyePose[ovrEye_Count];
 *     float HmdSpaceToWorldScaleInMeters;
 * }</pre></code>
 */
@NativeType("struct ovrViewScaleDesc")
public class OVRViewScaleDesc extends Struct implements NativeResource {

    /** The struct size in bytes. */
    public static final int SIZEOF;

    public static final int ALIGNOF;

    /** The struct member offsets. */
    public static final int
        HMDTOEYEPOSE,
        HMDSPACETOWORLDSCALEINMETERS;

    static {
        Layout layout = __struct(
            __array(OVRPosef.SIZEOF, OVRPosef.ALIGNOF, ovrEye_Count),
            __member(4)
        );

        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();

        HMDTOEYEPOSE = layout.offsetof(0);
        HMDSPACETOWORLDSCALEINMETERS = layout.offsetof(1);
    }

    OVRViewScaleDesc(long address, ByteBuffer container) {
        super(address, container);
    }

    /**
     * Creates a {@link OVRViewScaleDesc} instance at the current position of the specified {@link ByteBuffer} container. Changes to the buffer's content will be
     * visible to the struct instance and vice versa.
     *
     * <p>The created instance holds a strong reference to the container object.</p>
     */
    public OVRViewScaleDesc(ByteBuffer container) {
        this(memAddress(container), checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() { return SIZEOF; }

    /** Returns a {@link OVRPosef}.Buffer view of the {@code HmdToEyePose} field. */
    @NativeType("ovrPosef[ovrEye_Count]")
    public OVRPosef.Buffer HmdToEyePose() { return nHmdToEyePose(address()); }
    /** Returns a {@link OVRPosef} view of the struct at the specified index of the {@code HmdToEyePose} field. */
    @NativeType("ovrPosef")
    public OVRPosef HmdToEyePose(int index) { return nHmdToEyePose(address(), index); }
    /** Returns the value of the {@code HmdSpaceToWorldScaleInMeters} field. */
    public float HmdSpaceToWorldScaleInMeters() { return nHmdSpaceToWorldScaleInMeters(address()); }

    /** Copies the specified {@link OVRPosef.Buffer} to the {@code HmdToEyePose} field. */
    public OVRViewScaleDesc HmdToEyePose(@NativeType("ovrPosef[ovrEye_Count]") OVRPosef.Buffer value) { nHmdToEyePose(address(), value); return this; }
    /** Copies the specified {@link OVRPosef} at the specified index of the {@code HmdToEyePose} field. */
    public OVRViewScaleDesc HmdToEyePose(int index, @NativeType("ovrPosef") OVRPosef value) { nHmdToEyePose(address(), index, value); return this; }
    /** Sets the specified value to the {@code HmdSpaceToWorldScaleInMeters} field. */
    public OVRViewScaleDesc HmdSpaceToWorldScaleInMeters(float value) { nHmdSpaceToWorldScaleInMeters(address(), value); return this; }

    /** Initializes this struct with the specified values. */
    public OVRViewScaleDesc set(
        OVRPosef.Buffer HmdToEyePose,
        float HmdSpaceToWorldScaleInMeters
    ) {
        HmdToEyePose(HmdToEyePose);
        HmdSpaceToWorldScaleInMeters(HmdSpaceToWorldScaleInMeters);

        return this;
    }

    /**
     * Copies the specified struct data to this struct.
     *
     * @param src the source struct
     *
     * @return this struct
     */
    public OVRViewScaleDesc set(OVRViewScaleDesc src) {
        memCopy(src.address(), address(), SIZEOF);
        return this;
    }

    // -----------------------------------

    /** Returns a new {@link OVRViewScaleDesc} instance allocated with {@link MemoryUtil#memAlloc memAlloc}. The instance must be explicitly freed. */
    public static OVRViewScaleDesc malloc() {
        return create(nmemAlloc(SIZEOF));
    }

    /** Returns a new {@link OVRViewScaleDesc} instance allocated with {@link MemoryUtil#memCalloc memCalloc}. The instance must be explicitly freed. */
    public static OVRViewScaleDesc calloc() {
        return create(nmemCalloc(1, SIZEOF));
    }

    /** Returns a new {@link OVRViewScaleDesc} instance allocated with {@link BufferUtils}. */
    public static OVRViewScaleDesc create() {
        return new OVRViewScaleDesc(BufferUtils.createByteBuffer(SIZEOF));
    }

    /** Returns a new {@link OVRViewScaleDesc} instance for the specified memory address or {@code null} if the address is {@code NULL}. */
    public static OVRViewScaleDesc create(long address) {
        return address == NULL ? null : new OVRViewScaleDesc(address, null);
    }

    /**
     * Returns a new {@link OVRViewScaleDesc.Buffer} instance allocated with {@link MemoryUtil#memAlloc memAlloc}. The instance must be explicitly freed.
     *
     * @param capacity the buffer capacity
     */
    public static Buffer malloc(int capacity) {
        return create(__malloc(capacity, SIZEOF), capacity);
    }

    /**
     * Returns a new {@link OVRViewScaleDesc.Buffer} instance allocated with {@link MemoryUtil#memCalloc memCalloc}. The instance must be explicitly freed.
     *
     * @param capacity the buffer capacity
     */
    public static Buffer calloc(int capacity) {
        return create(nmemCalloc(capacity, SIZEOF), capacity);
    }

    /**
     * Returns a new {@link OVRViewScaleDesc.Buffer} instance allocated with {@link BufferUtils}.
     *
     * @param capacity the buffer capacity
     */
    public static Buffer create(int capacity) {
        return new Buffer(__create(capacity, SIZEOF));
    }

    /**
     * Create a {@link OVRViewScaleDesc.Buffer} instance at the specified memory.
     *
     * @param address  the memory address
     * @param capacity the buffer capacity
     */
    public static Buffer create(long address, int capacity) {
        return address == NULL ? null : new Buffer(address, null, -1, 0, capacity, capacity);
    }

    // -----------------------------------

    /** Returns a new {@link OVRViewScaleDesc} instance allocated on the thread-local {@link MemoryStack}. */
    public static OVRViewScaleDesc mallocStack() {
        return mallocStack(stackGet());
    }

    /** Returns a new {@link OVRViewScaleDesc} instance allocated on the thread-local {@link MemoryStack} and initializes all its bits to zero. */
    public static OVRViewScaleDesc callocStack() {
        return callocStack(stackGet());
    }

    /**
     * Returns a new {@link OVRViewScaleDesc} instance allocated on the specified {@link MemoryStack}.
     *
     * @param stack the stack from which to allocate
     */
    public static OVRViewScaleDesc mallocStack(MemoryStack stack) {
        return create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    /**
     * Returns a new {@link OVRViewScaleDesc} instance allocated on the specified {@link MemoryStack} and initializes all its bits to zero.
     *
     * @param stack the stack from which to allocate
     */
    public static OVRViewScaleDesc callocStack(MemoryStack stack) {
        return create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    /**
     * Returns a new {@link OVRViewScaleDesc.Buffer} instance allocated on the thread-local {@link MemoryStack}.
     *
     * @param capacity the buffer capacity
     */
    public static Buffer mallocStack(int capacity) {
        return mallocStack(capacity, stackGet());
    }

    /**
     * Returns a new {@link OVRViewScaleDesc.Buffer} instance allocated on the thread-local {@link MemoryStack} and initializes all its bits to zero.
     *
     * @param capacity the buffer capacity
     */
    public static Buffer callocStack(int capacity) {
        return callocStack(capacity, stackGet());
    }

    /**
     * Returns a new {@link OVRViewScaleDesc.Buffer} instance allocated on the specified {@link MemoryStack}.
     *
     * @param stack the stack from which to allocate
     * @param capacity the buffer capacity
     */
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    /**
     * Returns a new {@link OVRViewScaleDesc.Buffer} instance allocated on the specified {@link MemoryStack} and initializes all its bits to zero.
     *
     * @param stack the stack from which to allocate
     * @param capacity the buffer capacity
     */
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    // -----------------------------------

    /** Unsafe version of {@link #HmdToEyePose}. */
    public static OVRPosef.Buffer nHmdToEyePose(long struct) { return OVRPosef.create(struct + OVRViewScaleDesc.HMDTOEYEPOSE, ovrEye_Count); }
    /** Unsafe version of {@link #HmdToEyePose(int) HmdToEyePose}. */
    public static OVRPosef nHmdToEyePose(long struct, int index) {
        if (CHECKS) { check(index, ovrEye_Count); }
        return OVRPosef.create(struct + OVRViewScaleDesc.HMDTOEYEPOSE + index * OVRPosef.SIZEOF);
    }
    /** Unsafe version of {@link #HmdSpaceToWorldScaleInMeters}. */
    public static float nHmdSpaceToWorldScaleInMeters(long struct) { return memGetFloat(struct + OVRViewScaleDesc.HMDSPACETOWORLDSCALEINMETERS); }

    /** Unsafe version of {@link #HmdToEyePose(OVRPosef.Buffer) HmdToEyePose}. */
    public static void nHmdToEyePose(long struct, OVRPosef.Buffer value) {
        if (CHECKS) { checkGT(value, ovrEye_Count); }
        memCopy(value.address(), struct + OVRViewScaleDesc.HMDTOEYEPOSE, value.remaining() * OVRPosef.SIZEOF);
    }
    /** Unsafe version of {@link #HmdToEyePose(int, OVRPosef) HmdToEyePose}. */
    public static void nHmdToEyePose(long struct, int index, OVRPosef value) {
        if (CHECKS) { check(index, ovrEye_Count); }
        memCopy(value.address(), struct + OVRViewScaleDesc.HMDTOEYEPOSE + index * OVRPosef.SIZEOF, OVRPosef.SIZEOF);
    }
    /** Unsafe version of {@link #HmdSpaceToWorldScaleInMeters(float) HmdSpaceToWorldScaleInMeters}. */
    public static void nHmdSpaceToWorldScaleInMeters(long struct, float value) { memPutFloat(struct + OVRViewScaleDesc.HMDSPACETOWORLDSCALEINMETERS, value); }

    // -----------------------------------

    /** An array of {@link OVRViewScaleDesc} structs. */
    public static class Buffer extends StructBuffer<OVRViewScaleDesc, Buffer> implements NativeResource {

        /**
         * Creates a new {@link OVRViewScaleDesc.Buffer} instance backed by the specified container.
         *
         * Changes to the container's content will be visible to the struct buffer instance and vice versa. The two buffers' position, limit, and mark values
         * will be independent. The new buffer's position will be zero, its capacity and its limit will be the number of bytes remaining in this buffer divided
         * by {@link OVRViewScaleDesc#SIZEOF}, and its mark will be undefined.
         *
         * <p>The created buffer instance holds a strong reference to the container object.</p>
         */
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        Buffer(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected OVRViewScaleDesc newInstance(long address) {
            return new OVRViewScaleDesc(address, container);
        }

        @Override
        public int sizeof() {
            return SIZEOF;
        }

        /** Returns a {@link OVRPosef}.Buffer view of the {@code HmdToEyePose} field. */
        @NativeType("ovrPosef[ovrEye_Count]")
        public OVRPosef.Buffer HmdToEyePose() { return OVRViewScaleDesc.nHmdToEyePose(address()); }
        /** Returns a {@link OVRPosef} view of the struct at the specified index of the {@code HmdToEyePose} field. */
        @NativeType("ovrPosef")
        public OVRPosef HmdToEyePose(int index) { return OVRViewScaleDesc.nHmdToEyePose(address(), index); }
        /** Returns the value of the {@code HmdSpaceToWorldScaleInMeters} field. */
        public float HmdSpaceToWorldScaleInMeters() { return OVRViewScaleDesc.nHmdSpaceToWorldScaleInMeters(address()); }

        /** Copies the specified {@link OVRPosef.Buffer} to the {@code HmdToEyePose} field. */
        public OVRViewScaleDesc.Buffer HmdToEyePose(@NativeType("ovrPosef[ovrEye_Count]") OVRPosef.Buffer value) { OVRViewScaleDesc.nHmdToEyePose(address(), value); return this; }
        /** Copies the specified {@link OVRPosef} at the specified index of the {@code HmdToEyePose} field. */
        public OVRViewScaleDesc.Buffer HmdToEyePose(int index, @NativeType("ovrPosef") OVRPosef value) { OVRViewScaleDesc.nHmdToEyePose(address(), index, value); return this; }
        /** Sets the specified value to the {@code HmdSpaceToWorldScaleInMeters} field. */
        public OVRViewScaleDesc.Buffer HmdSpaceToWorldScaleInMeters(float value) { OVRViewScaleDesc.nHmdSpaceToWorldScaleInMeters(address(), value); return this; }

    }

}