/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.ktx;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.util.ktx.ktxStream_destruct;
import org.lwjgl.util.ktx.ktxStream_destructI;
import org.lwjgl.util.ktx.ktxStream_getpos;
import org.lwjgl.util.ktx.ktxStream_getposI;
import org.lwjgl.util.ktx.ktxStream_getsize;
import org.lwjgl.util.ktx.ktxStream_getsizeI;
import org.lwjgl.util.ktx.ktxStream_read;
import org.lwjgl.util.ktx.ktxStream_readI;
import org.lwjgl.util.ktx.ktxStream_setpos;
import org.lwjgl.util.ktx.ktxStream_setposI;
import org.lwjgl.util.ktx.ktxStream_skip;
import org.lwjgl.util.ktx.ktxStream_skipI;
import org.lwjgl.util.ktx.ktxStream_write;
import org.lwjgl.util.ktx.ktxStream_writeI;

@NativeType(value="struct ktxStream")
public class ktxStream
extends Struct<ktxStream>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int READ;
    public static final int SKIP;
    public static final int WRITE;
    public static final int GETPOS;
    public static final int SETPOS;
    public static final int GETSIZE;
    public static final int DESTRUCT;
    public static final int TYPE;
    public static final int DATA;
    public static final int DATA_FILE;
    public static final int DATA_MEM;
    public static final int DATA_CUSTOM_PTR;
    public static final int DATA_CUSTOM_PTR_ADDRESS;
    public static final int DATA_CUSTOM_PTR_ALLOCATORADDRESS;
    public static final int DATA_CUSTOM_PTR_SIZE;
    public static final int READPOS;
    public static final int CLOSEONDESTRUCT;

    protected ktxStream(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected ktxStream create(long address, @Nullable ByteBuffer container) {
        return new ktxStream(address, container);
    }

    public ktxStream(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), ktxStream.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    public ktxStream_read read() {
        return ktxStream.nread(this.address());
    }

    public ktxStream_skip skip() {
        return ktxStream.nskip(this.address());
    }

    public ktxStream_write write() {
        return ktxStream.nwrite(this.address());
    }

    public ktxStream_getpos getpos() {
        return ktxStream.ngetpos(this.address());
    }

    public ktxStream_setpos setpos() {
        return ktxStream.nsetpos(this.address());
    }

    public ktxStream_getsize getsize() {
        return ktxStream.ngetsize(this.address());
    }

    public ktxStream_destruct destruct() {
        return ktxStream.ndestruct(this.address());
    }

    @NativeType(value="enum streamType")
    public int type() {
        return ktxStream.ntype(this.address());
    }

    @NativeType(value="FILE *")
    public long data_file() {
        return ktxStream.ndata_file(this.address());
    }

    @NativeType(value="ktxMem *")
    public long data_mem() {
        return ktxStream.ndata_mem(this.address());
    }

    @NativeType(value="void *")
    public ByteBuffer data_custom_ptr_address(int capacity) {
        return ktxStream.ndata_custom_ptr_address(this.address(), capacity);
    }

    @NativeType(value="void *")
    public long data_custom_ptr_allocatorAddress() {
        return ktxStream.ndata_custom_ptr_allocatorAddress(this.address());
    }

    @NativeType(value="ktx_size_t")
    public long data_custom_ptr_size() {
        return ktxStream.ndata_custom_ptr_size(this.address());
    }

    @NativeType(value="ktx_off_t")
    public long readpos() {
        return ktxStream.nreadpos(this.address());
    }

    @NativeType(value="ktx_bool_t")
    public boolean closeOnDestruct() {
        return ktxStream.ncloseOnDestruct(this.address());
    }

    public ktxStream read(@NativeType(value="ktxStream_read") ktxStream_readI value) {
        ktxStream.nread(this.address(), value);
        return this;
    }

    public ktxStream skip(@NativeType(value="ktxStream_skip") ktxStream_skipI value) {
        ktxStream.nskip(this.address(), value);
        return this;
    }

    public ktxStream write(@NativeType(value="ktxStream_write") ktxStream_writeI value) {
        ktxStream.nwrite(this.address(), value);
        return this;
    }

    public ktxStream getpos(@NativeType(value="ktxStream_getpos") ktxStream_getposI value) {
        ktxStream.ngetpos(this.address(), value);
        return this;
    }

    public ktxStream setpos(@NativeType(value="ktxStream_setpos") ktxStream_setposI value) {
        ktxStream.nsetpos(this.address(), value);
        return this;
    }

    public ktxStream getsize(@NativeType(value="ktxStream_getsize") ktxStream_getsizeI value) {
        ktxStream.ngetsize(this.address(), value);
        return this;
    }

    public ktxStream destruct(@NativeType(value="ktxStream_destruct") ktxStream_destructI value) {
        ktxStream.ndestruct(this.address(), value);
        return this;
    }

    public ktxStream type(@NativeType(value="enum streamType") int value) {
        ktxStream.ntype(this.address(), value);
        return this;
    }

    public ktxStream data_file(@NativeType(value="FILE *") long value) {
        ktxStream.ndata_file(this.address(), value);
        return this;
    }

    public ktxStream data_mem(@NativeType(value="ktxMem *") long value) {
        ktxStream.ndata_mem(this.address(), value);
        return this;
    }

    public ktxStream data_custom_ptr_address(@NativeType(value="void *") ByteBuffer value) {
        ktxStream.ndata_custom_ptr_address(this.address(), value);
        return this;
    }

    public ktxStream data_custom_ptr_allocatorAddress(@NativeType(value="void *") long value) {
        ktxStream.ndata_custom_ptr_allocatorAddress(this.address(), value);
        return this;
    }

    public ktxStream data_custom_ptr_size(@NativeType(value="ktx_size_t") long value) {
        ktxStream.ndata_custom_ptr_size(this.address(), value);
        return this;
    }

    public ktxStream readpos(@NativeType(value="ktx_off_t") long value) {
        ktxStream.nreadpos(this.address(), value);
        return this;
    }

    public ktxStream closeOnDestruct(@NativeType(value="ktx_bool_t") boolean value) {
        ktxStream.ncloseOnDestruct(this.address(), value);
        return this;
    }

    public ktxStream set(ktxStream src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static ktxStream malloc() {
        return new ktxStream(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static ktxStream calloc() {
        return new ktxStream(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static ktxStream create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new ktxStream(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static ktxStream create(long address) {
        return new ktxStream(address, null);
    }

    public static @Nullable ktxStream createSafe(long address) {
        return address == 0L ? null : new ktxStream(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)ktxStream.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = ktxStream.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static ktxStream malloc(MemoryStack stack) {
        return new ktxStream(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static ktxStream calloc(MemoryStack stack) {
        return new ktxStream(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static ktxStream_read nread(long struct) {
        return ktxStream_read.create(MemoryUtil.memGetAddress((long)(struct + (long)READ)));
    }

    public static ktxStream_skip nskip(long struct) {
        return ktxStream_skip.create(MemoryUtil.memGetAddress((long)(struct + (long)SKIP)));
    }

    public static ktxStream_write nwrite(long struct) {
        return ktxStream_write.create(MemoryUtil.memGetAddress((long)(struct + (long)WRITE)));
    }

    public static ktxStream_getpos ngetpos(long struct) {
        return ktxStream_getpos.create(MemoryUtil.memGetAddress((long)(struct + (long)GETPOS)));
    }

    public static ktxStream_setpos nsetpos(long struct) {
        return ktxStream_setpos.create(MemoryUtil.memGetAddress((long)(struct + (long)SETPOS)));
    }

    public static ktxStream_getsize ngetsize(long struct) {
        return ktxStream_getsize.create(MemoryUtil.memGetAddress((long)(struct + (long)GETSIZE)));
    }

    public static ktxStream_destruct ndestruct(long struct) {
        return ktxStream_destruct.create(MemoryUtil.memGetAddress((long)(struct + (long)DESTRUCT)));
    }

    public static int ntype(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)TYPE));
    }

    public static long ndata_file(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)DATA_FILE));
    }

    public static long ndata_mem(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)DATA_MEM));
    }

    public static ByteBuffer ndata_custom_ptr_address(long struct, int capacity) {
        return MemoryUtil.memByteBuffer((long)MemoryUtil.memGetAddress((long)(struct + (long)DATA_CUSTOM_PTR_ADDRESS)), (int)capacity);
    }

    public static long ndata_custom_ptr_allocatorAddress(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)DATA_CUSTOM_PTR_ALLOCATORADDRESS));
    }

    public static long ndata_custom_ptr_size(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)DATA_CUSTOM_PTR_SIZE));
    }

    public static long nreadpos(long struct) {
        return MemoryUtil.memGetLong((long)(struct + (long)READPOS));
    }

    public static boolean ncloseOnDestruct(long struct) {
        return MemoryUtil.memGetByte((long)(struct + (long)CLOSEONDESTRUCT)) != 0;
    }

    public static void nread(long struct, ktxStream_readI value) {
        MemoryUtil.memPutAddress((long)(struct + (long)READ), (long)value.address());
    }

    public static void nskip(long struct, ktxStream_skipI value) {
        MemoryUtil.memPutAddress((long)(struct + (long)SKIP), (long)value.address());
    }

    public static void nwrite(long struct, ktxStream_writeI value) {
        MemoryUtil.memPutAddress((long)(struct + (long)WRITE), (long)value.address());
    }

    public static void ngetpos(long struct, ktxStream_getposI value) {
        MemoryUtil.memPutAddress((long)(struct + (long)GETPOS), (long)value.address());
    }

    public static void nsetpos(long struct, ktxStream_setposI value) {
        MemoryUtil.memPutAddress((long)(struct + (long)SETPOS), (long)value.address());
    }

    public static void ngetsize(long struct, ktxStream_getsizeI value) {
        MemoryUtil.memPutAddress((long)(struct + (long)GETSIZE), (long)value.address());
    }

    public static void ndestruct(long struct, ktxStream_destructI value) {
        MemoryUtil.memPutAddress((long)(struct + (long)DESTRUCT), (long)value.address());
    }

    public static void ntype(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)TYPE), (int)value);
    }

    public static void ndata_file(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)DATA_FILE), (long)Checks.check((long)value));
    }

    public static void ndata_mem(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)DATA_MEM), (long)Checks.check((long)value));
    }

    public static void ndata_custom_ptr_address(long struct, ByteBuffer value) {
        MemoryUtil.memPutAddress((long)(struct + (long)DATA_CUSTOM_PTR_ADDRESS), (long)MemoryUtil.memAddress((ByteBuffer)value));
    }

    public static void ndata_custom_ptr_allocatorAddress(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)DATA_CUSTOM_PTR_ALLOCATORADDRESS), (long)value);
    }

    public static void ndata_custom_ptr_size(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)DATA_CUSTOM_PTR_SIZE), (long)value);
    }

    public static void nreadpos(long struct, long value) {
        MemoryUtil.memPutLong((long)(struct + (long)READPOS), (long)value);
    }

    public static void ncloseOnDestruct(long struct, boolean value) {
        MemoryUtil.memPutByte((long)(struct + (long)CLOSEONDESTRUCT), (byte)(value ? (byte)1 : 0));
    }

    public static void validate(long struct) {
        Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)READ)));
        Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)SKIP)));
        Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)WRITE)));
        Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)GETPOS)));
        Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)SETPOS)));
        Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)GETSIZE)));
        Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)DESTRUCT)));
    }

    static {
        Struct.Layout layout = ktxStream.__struct((Struct.Member[])new Struct.Member[]{ktxStream.__member((int)POINTER_SIZE), ktxStream.__member((int)POINTER_SIZE), ktxStream.__member((int)POINTER_SIZE), ktxStream.__member((int)POINTER_SIZE), ktxStream.__member((int)POINTER_SIZE), ktxStream.__member((int)POINTER_SIZE), ktxStream.__member((int)POINTER_SIZE), ktxStream.__member((int)4), ktxStream.__union((Struct.Member[])new Struct.Member[]{ktxStream.__member((int)POINTER_SIZE), ktxStream.__member((int)POINTER_SIZE), ktxStream.__struct((Struct.Member[])new Struct.Member[]{ktxStream.__member((int)POINTER_SIZE), ktxStream.__member((int)POINTER_SIZE), ktxStream.__member((int)POINTER_SIZE)})}), ktxStream.__member((int)8), ktxStream.__member((int)1)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        READ = layout.offsetof(0);
        SKIP = layout.offsetof(1);
        WRITE = layout.offsetof(2);
        GETPOS = layout.offsetof(3);
        SETPOS = layout.offsetof(4);
        GETSIZE = layout.offsetof(5);
        DESTRUCT = layout.offsetof(6);
        TYPE = layout.offsetof(7);
        DATA = layout.offsetof(8);
        DATA_FILE = layout.offsetof(9);
        DATA_MEM = layout.offsetof(10);
        DATA_CUSTOM_PTR = layout.offsetof(11);
        DATA_CUSTOM_PTR_ADDRESS = layout.offsetof(12);
        DATA_CUSTOM_PTR_ALLOCATORADDRESS = layout.offsetof(13);
        DATA_CUSTOM_PTR_SIZE = layout.offsetof(14);
        READPOS = layout.offsetof(15);
        CLOSEONDESTRUCT = layout.offsetof(16);
    }

    public static class Buffer
    extends StructBuffer<ktxStream, Buffer>
    implements NativeResource {
        private static final ktxStream ELEMENT_FACTORY = ktxStream.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        protected ktxStream getElementFactory() {
            return ELEMENT_FACTORY;
        }

        public ktxStream_read read() {
            return ktxStream.nread(this.address());
        }

        public ktxStream_skip skip() {
            return ktxStream.nskip(this.address());
        }

        public ktxStream_write write() {
            return ktxStream.nwrite(this.address());
        }

        public ktxStream_getpos getpos() {
            return ktxStream.ngetpos(this.address());
        }

        public ktxStream_setpos setpos() {
            return ktxStream.nsetpos(this.address());
        }

        public ktxStream_getsize getsize() {
            return ktxStream.ngetsize(this.address());
        }

        public ktxStream_destruct destruct() {
            return ktxStream.ndestruct(this.address());
        }

        @NativeType(value="enum streamType")
        public int type() {
            return ktxStream.ntype(this.address());
        }

        @NativeType(value="FILE *")
        public long data_file() {
            return ktxStream.ndata_file(this.address());
        }

        @NativeType(value="ktxMem *")
        public long data_mem() {
            return ktxStream.ndata_mem(this.address());
        }

        @NativeType(value="void *")
        public ByteBuffer data_custom_ptr_address(int capacity) {
            return ktxStream.ndata_custom_ptr_address(this.address(), capacity);
        }

        @NativeType(value="void *")
        public long data_custom_ptr_allocatorAddress() {
            return ktxStream.ndata_custom_ptr_allocatorAddress(this.address());
        }

        @NativeType(value="ktx_size_t")
        public long data_custom_ptr_size() {
            return ktxStream.ndata_custom_ptr_size(this.address());
        }

        @NativeType(value="ktx_off_t")
        public long readpos() {
            return ktxStream.nreadpos(this.address());
        }

        @NativeType(value="ktx_bool_t")
        public boolean closeOnDestruct() {
            return ktxStream.ncloseOnDestruct(this.address());
        }

        public Buffer read(@NativeType(value="ktxStream_read") ktxStream_readI value) {
            ktxStream.nread(this.address(), value);
            return this;
        }

        public Buffer skip(@NativeType(value="ktxStream_skip") ktxStream_skipI value) {
            ktxStream.nskip(this.address(), value);
            return this;
        }

        public Buffer write(@NativeType(value="ktxStream_write") ktxStream_writeI value) {
            ktxStream.nwrite(this.address(), value);
            return this;
        }

        public Buffer getpos(@NativeType(value="ktxStream_getpos") ktxStream_getposI value) {
            ktxStream.ngetpos(this.address(), value);
            return this;
        }

        public Buffer setpos(@NativeType(value="ktxStream_setpos") ktxStream_setposI value) {
            ktxStream.nsetpos(this.address(), value);
            return this;
        }

        public Buffer getsize(@NativeType(value="ktxStream_getsize") ktxStream_getsizeI value) {
            ktxStream.ngetsize(this.address(), value);
            return this;
        }

        public Buffer destruct(@NativeType(value="ktxStream_destruct") ktxStream_destructI value) {
            ktxStream.ndestruct(this.address(), value);
            return this;
        }

        public Buffer type(@NativeType(value="enum streamType") int value) {
            ktxStream.ntype(this.address(), value);
            return this;
        }

        public Buffer data_file(@NativeType(value="FILE *") long value) {
            ktxStream.ndata_file(this.address(), value);
            return this;
        }

        public Buffer data_mem(@NativeType(value="ktxMem *") long value) {
            ktxStream.ndata_mem(this.address(), value);
            return this;
        }

        public Buffer data_custom_ptr_address(@NativeType(value="void *") ByteBuffer value) {
            ktxStream.ndata_custom_ptr_address(this.address(), value);
            return this;
        }

        public Buffer data_custom_ptr_allocatorAddress(@NativeType(value="void *") long value) {
            ktxStream.ndata_custom_ptr_allocatorAddress(this.address(), value);
            return this;
        }

        public Buffer data_custom_ptr_size(@NativeType(value="ktx_size_t") long value) {
            ktxStream.ndata_custom_ptr_size(this.address(), value);
            return this;
        }

        public Buffer readpos(@NativeType(value="ktx_off_t") long value) {
            ktxStream.nreadpos(this.address(), value);
            return this;
        }

        public Buffer closeOnDestruct(@NativeType(value="ktx_bool_t") boolean value) {
            ktxStream.ncloseOnDestruct(this.address(), value);
            return this;
        }
    }
}

