/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.transactions;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.util.CbStrings;
import com.couchbase.client.core.util.Validators;
import reactor.util.annotation.Nullable;

@Stability.Internal
public class TransactionKeyspace {
    private final String bucket;
    private final String scope;
    private final String collection;

    private TransactionKeyspace(String bucket, @Nullable String scope, @Nullable String collection) {
        this.bucket = (String)Validators.notNull((Object)bucket, (String)"bucket");
        this.scope = CbStrings.isNullOrEmpty((String)scope) ? "_default" : scope;
        this.collection = CbStrings.isNullOrEmpty((String)collection) ? "_default" : collection;
    }

    public static TransactionKeyspace create(String bucket) {
        return new TransactionKeyspace(bucket, null, null);
    }

    public static TransactionKeyspace create(String bucket, String collection) {
        return new TransactionKeyspace(bucket, null, collection);
    }

    public static TransactionKeyspace create(String bucket, String scope, String collection) {
        return new TransactionKeyspace(bucket, scope, collection);
    }

    public String bucket() {
        return this.bucket;
    }

    public String scope() {
        return this.scope;
    }

    public String collection() {
        return this.collection;
    }

    public String toString() {
        return "TransactionKeyspace{bucket='" + this.bucket + '\'' + ", scope='" + this.scope + '\'' + ", collection='" + this.collection + '\'' + '}';
    }
}

