/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.manager.search;

import com.couchbase.client.java.AsyncUtils;
import com.couchbase.client.java.json.JsonObject;
import com.couchbase.client.java.manager.search.AllowQueryingSearchIndexOptions;
import com.couchbase.client.java.manager.search.AnalyzeDocumentOptions;
import com.couchbase.client.java.manager.search.AsyncSearchIndexManager;
import com.couchbase.client.java.manager.search.DisallowQueryingSearchIndexOptions;
import com.couchbase.client.java.manager.search.DropSearchIndexOptions;
import com.couchbase.client.java.manager.search.FreezePlanSearchIndexOptions;
import com.couchbase.client.java.manager.search.GetAllSearchIndexesOptions;
import com.couchbase.client.java.manager.search.GetIndexedSearchIndexOptions;
import com.couchbase.client.java.manager.search.GetSearchIndexOptions;
import com.couchbase.client.java.manager.search.PauseIngestSearchIndexOptions;
import com.couchbase.client.java.manager.search.ResumeIngestSearchIndexOptions;
import com.couchbase.client.java.manager.search.SearchIndex;
import com.couchbase.client.java.manager.search.UnfreezePlanSearchIndexOptions;
import com.couchbase.client.java.manager.search.UpsertSearchIndexOptions;
import java.util.List;

public class SearchIndexManager {
    private final AsyncSearchIndexManager asyncIndexManager;

    public SearchIndexManager(AsyncSearchIndexManager asyncIndexManager) {
        this.asyncIndexManager = asyncIndexManager;
    }

    public SearchIndex getIndex(String name, GetSearchIndexOptions options) {
        return AsyncUtils.block(this.asyncIndexManager.getIndex(name, options));
    }

    public List<SearchIndex> getAllIndexes(GetAllSearchIndexesOptions options) {
        return AsyncUtils.block(this.asyncIndexManager.getAllIndexes(options));
    }

    public long getIndexedDocumentsCount(String name, GetIndexedSearchIndexOptions options) {
        return AsyncUtils.block(this.asyncIndexManager.getIndexedDocumentsCount(name, options));
    }

    public List<JsonObject> analyzeDocument(String name, JsonObject document, AnalyzeDocumentOptions options) {
        return AsyncUtils.block(this.asyncIndexManager.analyzeDocument(name, document, options));
    }

    public void upsertIndex(SearchIndex index, UpsertSearchIndexOptions options) {
        AsyncUtils.block(this.asyncIndexManager.upsertIndex(index, options));
    }

    public void dropIndex(String name, DropSearchIndexOptions options) {
        AsyncUtils.block(this.asyncIndexManager.dropIndex(name, options));
    }

    public void pauseIngest(String name, PauseIngestSearchIndexOptions options) {
        AsyncUtils.block(this.asyncIndexManager.pauseIngest(name, options));
    }

    public void resumeIngest(String name, ResumeIngestSearchIndexOptions options) {
        AsyncUtils.block(this.asyncIndexManager.resumeIngest(name, options));
    }

    public void allowQuerying(String name, AllowQueryingSearchIndexOptions options) {
        AsyncUtils.block(this.asyncIndexManager.allowQuerying(name, options));
    }

    public void disallowQuerying(String name, DisallowQueryingSearchIndexOptions options) {
        AsyncUtils.block(this.asyncIndexManager.disallowQuerying(name, options));
    }

    public void freezePlan(String name, FreezePlanSearchIndexOptions options) {
        AsyncUtils.block(this.asyncIndexManager.freezePlan(name, options));
    }

    public void unfreezePlan(String name, UnfreezePlanSearchIndexOptions options) {
        AsyncUtils.block(this.asyncIndexManager.unfreezePlan(name, options));
    }

    public SearchIndex getIndex(String name) {
        return this.getIndex(name, GetSearchIndexOptions.getSearchIndexOptions());
    }

    public List<SearchIndex> getAllIndexes() {
        return this.getAllIndexes(GetAllSearchIndexesOptions.getAllSearchIndexesOptions());
    }

    public long getIndexedDocumentsCount(String name) {
        return this.getIndexedDocumentsCount(name, GetIndexedSearchIndexOptions.getIndexedSearchIndexOptions());
    }

    public List<JsonObject> analyzeDocument(String name, JsonObject document) {
        return this.analyzeDocument(name, document, AnalyzeDocumentOptions.analyzeDocumentOptions());
    }

    public void upsertIndex(SearchIndex index) {
        this.upsertIndex(index, UpsertSearchIndexOptions.upsertSearchIndexOptions());
    }

    public void dropIndex(String name) {
        this.dropIndex(name, DropSearchIndexOptions.dropSearchIndexOptions());
    }

    public void pauseIngest(String name) {
        this.pauseIngest(name, PauseIngestSearchIndexOptions.pauseIngestSearchIndexOptions());
    }

    public void resumeIngest(String name) {
        this.resumeIngest(name, ResumeIngestSearchIndexOptions.resumeIngestSearchIndexOptions());
    }

    public void allowQuerying(String name) {
        this.allowQuerying(name, AllowQueryingSearchIndexOptions.allowQueryingSearchIndexOptions());
    }

    public void disallowQuerying(String name) {
        this.disallowQuerying(name, DisallowQueryingSearchIndexOptions.disallowQueryingSearchIndexOptions());
    }

    public void freezePlan(String name) {
        this.freezePlan(name, FreezePlanSearchIndexOptions.freezePlanSearchIndexOptions());
    }

    public void unfreezePlan(String name) {
        this.unfreezePlan(name, UnfreezePlanSearchIndexOptions.unfreezePlanSearchIndexOptions());
    }
}

