/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.kv;

import com.couchbase.client.core.Core;
import com.couchbase.client.core.error.DefaultErrorUtil;
import com.couchbase.client.core.error.DocumentNotFoundException;
import com.couchbase.client.core.error.context.KeyValueErrorContext;
import com.couchbase.client.core.msg.Request;
import com.couchbase.client.core.msg.Response;
import com.couchbase.client.core.msg.ResponseStatus;
import com.couchbase.client.core.msg.kv.KeyValueRequest;
import com.couchbase.client.core.msg.kv.SubdocGetRequest;
import com.couchbase.client.java.codec.JsonSerializer;
import com.couchbase.client.java.kv.LookupInResult;
import java.util.concurrent.CompletableFuture;

public class LookupInAccessor {
    public static CompletableFuture<LookupInResult> lookupInAccessor(Core core, SubdocGetRequest request, JsonSerializer serializer) {
        core.send((Request)request);
        return ((CompletableFuture)request.response().thenApply(response -> {
            if (response.status().success()) {
                return new LookupInResult(response.values(), response.cas(), serializer, null, response.isDeleted());
            }
            if (response.status() == ResponseStatus.SUBDOC_FAILURE) {
                KeyValueErrorContext ctx = KeyValueErrorContext.completedRequest((KeyValueRequest)request, (Response)response);
                return new LookupInResult(response.values(), response.cas(), serializer, ctx, response.isDeleted());
            }
            throw DefaultErrorUtil.keyValueStatusToException((KeyValueRequest)request, (Response)response);
        })).whenComplete((t, e) -> {
            if (e == null || e instanceof DocumentNotFoundException) {
                request.context().logicallyComplete();
            } else {
                request.context().logicallyComplete(e);
            }
        });
    }
}

