/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java;

import com.couchbase.client.core.Core;
import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.api.query.CoreQueryOptions;
import com.couchbase.client.core.error.context.ReducedQueryErrorContext;
import com.couchbase.client.core.util.Validators;
import com.couchbase.client.java.AsyncScope;
import com.couchbase.client.java.AsyncUtils;
import com.couchbase.client.java.Collection;
import com.couchbase.client.java.ReactiveCluster;
import com.couchbase.client.java.ReactiveScope;
import com.couchbase.client.java.analytics.AnalyticsOptions;
import com.couchbase.client.java.analytics.AnalyticsResult;
import com.couchbase.client.java.codec.JsonSerializer;
import com.couchbase.client.java.env.ClusterEnvironment;
import com.couchbase.client.java.query.QueryAccessor;
import com.couchbase.client.java.query.QueryOptions;
import com.couchbase.client.java.query.QueryResult;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class Scope {
    private final AsyncScope asyncScope;
    private final ReactiveScope reactiveScope;
    private final Map<String, Collection> collectionCache = new ConcurrentHashMap<String, Collection>();

    Scope(AsyncScope asyncScope) {
        this.asyncScope = asyncScope;
        this.reactiveScope = new ReactiveScope(asyncScope);
    }

    public String name() {
        return this.asyncScope.name();
    }

    public String bucketName() {
        return this.asyncScope.bucketName();
    }

    public AsyncScope async() {
        return this.asyncScope;
    }

    public ReactiveScope reactive() {
        return this.reactiveScope;
    }

    @Stability.Volatile
    public Core core() {
        return this.asyncScope.core();
    }

    public ClusterEnvironment environment() {
        return this.asyncScope.environment();
    }

    Collection defaultCollection() {
        return this.collectionCache.computeIfAbsent("_default", n -> new Collection(this.asyncScope.defaultCollection()));
    }

    public Collection collection(String collectionName) {
        return this.collectionCache.computeIfAbsent(collectionName, n -> new Collection(this.asyncScope.collection((String)n)));
    }

    public QueryResult query(String statement) {
        return this.query(statement, ReactiveCluster.DEFAULT_QUERY_OPTIONS);
    }

    public QueryResult query(String statement, QueryOptions options) {
        Validators.notNull((Object)options, (String)"QueryOptions", () -> new ReducedQueryErrorContext(statement));
        QueryOptions.Built opts = options.build();
        JsonSerializer serializer = opts.serializer() == null ? this.environment().jsonSerializer() : opts.serializer();
        return new QueryResult(this.async().queryOps.queryBlocking(statement, (CoreQueryOptions)opts, this.asyncScope.queryContext, null, QueryAccessor::convertCoreQueryError), serializer);
    }

    public AnalyticsResult analyticsQuery(String statement) {
        return this.analyticsQuery(statement, ReactiveCluster.DEFAULT_ANALYTICS_OPTIONS);
    }

    public AnalyticsResult analyticsQuery(String statement, AnalyticsOptions options) {
        return AsyncUtils.block(this.async().analyticsQuery(statement, options));
    }
}

