/*
 * Decompiled with CFR 0.152.
 */
package org.lorislab.p6.process.model.runtime;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.deser.BeanDeserializerModifier;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.fasterxml.jackson.dataformat.yaml.YAMLGenerator;
import java.io.File;
import org.lorislab.p6.process.model.NodeNameDeserializer;
import org.lorislab.p6.process.model.ProcessDefinition;
import org.lorislab.p6.process.model.runtime.ProcessDefinitionRuntime;

public class ProcessDefinitionLoader {
    private static final ObjectReader PROCESS_DEF_READER;
    private static final ObjectWriter PROCESS_DEF_WRITER;
    private static final ObjectReader PROCESS_DEF_RUNTIME_READER;

    public static void registerJsonMapKeyAnnotation(ObjectMapper objectMapper) {
        SimpleModule module = new SimpleModule();
        module.setDeserializerModifier(new BeanDeserializerModifier(){

            public JsonDeserializer<?> modifyDeserializer(DeserializationConfig config, BeanDescription beanDescription, JsonDeserializer<?> originalDeserializer) {
                return new NodeNameDeserializer(originalDeserializer, beanDescription);
            }
        });
        objectMapper.registerModule((Module)module);
    }

    public static ProcessDefinitionRuntime loadRuntime(File file) {
        try {
            return (ProcessDefinitionRuntime)PROCESS_DEF_RUNTIME_READER.readValue(file);
        }
        catch (Exception ex) {
            throw new IllegalStateException("Error read process runtime definition from file", ex);
        }
    }

    public static ProcessDefinitionRuntime loadRuntime(String data) {
        try {
            return (ProcessDefinitionRuntime)PROCESS_DEF_RUNTIME_READER.readValue(data);
        }
        catch (Exception ex) {
            throw new IllegalStateException("Error read process runtime definition", ex);
        }
    }

    public static ProcessDefinition load(File file) {
        try {
            return (ProcessDefinition)PROCESS_DEF_READER.readValue(file);
        }
        catch (Exception ex) {
            throw new IllegalStateException("Error read process definition from file", ex);
        }
    }

    public static ProcessDefinition load(String data) {
        try {
            return (ProcessDefinition)PROCESS_DEF_READER.readValue(data);
        }
        catch (Exception ex) {
            throw new IllegalStateException("Error read process definition", ex);
        }
    }

    public static String toString(ProcessDefinition pd) {
        try {
            return PROCESS_DEF_WRITER.writeValueAsString((Object)pd);
        }
        catch (Exception ex) {
            throw new IllegalStateException("Error write the process definition", ex);
        }
    }

    public static void toFile(File file, ProcessDefinition pd) {
        try {
            PROCESS_DEF_WRITER.writeValue(file, (Object)pd);
        }
        catch (Exception ex) {
            throw new IllegalStateException("Error write the process definition to file", ex);
        }
    }

    private ProcessDefinitionLoader() {
    }

    static {
        ObjectMapper mapper = new ObjectMapper((JsonFactory)new YAMLFactory().enable(YAMLGenerator.Feature.MINIMIZE_QUOTES).disable(YAMLGenerator.Feature.USE_NATIVE_OBJECT_ID).disable(YAMLGenerator.Feature.USE_NATIVE_TYPE_ID).disable(YAMLGenerator.Feature.WRITE_DOC_START_MARKER));
        ProcessDefinitionLoader.registerJsonMapKeyAnnotation(mapper);
        PROCESS_DEF_READER = mapper.readerFor(ProcessDefinition.class);
        PROCESS_DEF_WRITER = mapper.writerFor(ProcessDefinition.class);
        PROCESS_DEF_RUNTIME_READER = mapper.readerFor(ProcessDefinitionRuntime.class);
    }
}

