package org.lorislab.p6.process.flow.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import javax.validation.Valid;
import javax.validation.constraints.*;

@JsonTypeInfo(
    use = JsonTypeInfo.Id.NAME,
    include = JsonTypeInfo.As.PROPERTY,
    property = "nodeType",
    visible = true)
@JsonSubTypes({
  @JsonSubTypes.Type(value = ServiceTask.class, name = "SERVICE_TASK"),
  @JsonSubTypes.Type(value = ExclusiveGateway.class, name = "EXCLUSIVE_GATEWAY"),
  @JsonSubTypes.Type(value = ScriptTask.class, name = "SCRIPT_TASK"),
  @JsonSubTypes.Type(value = InclusiveGateway.class, name = "INCLUSIVE_GATEWAY"),
  @JsonSubTypes.Type(value = Gateway.class, name = "Gateway"),
  @JsonSubTypes.Type(value = ParallelGateway.class, name = "PARALLEL_GATEWAY"),
  @JsonSubTypes.Type(value = StartEvent.class, name = "START_EVENT"),
  @JsonSubTypes.Type(value = EndEvent.class, name = "END_EVENT"),
})
@lombok.ToString(callSuper = true)
@io.quarkus.runtime.annotations.RegisterForReflection
public class Node {

  @JsonProperty(value = "name", required = false)
  public @Valid String name = null;

  @JsonProperty(value = "sequence", required = false)
  public @Valid Sequence sequence = null;

  @JsonProperty(value = "nodeType", required = true)
  public @Valid NodeType nodeType = null;
}
