/*
 * Copyright 2019 lorislab.org.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.lorislab.p6.process.deployment;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import org.lorislab.p6.process.flow.model.Node;
import org.lorislab.p6.process.flow.model.ProcessDefinition;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@JsonDeserialize(converter = ProcessDefinitionDeserializer.class)
public class ProcessDefinitionModel extends ProcessDefinition {

    public List<Node> start = new ArrayList<>();

    public Map<String, Node> nodes = new HashMap<>();

    public Node getNode(String name) {
        return nodes.get(name);
    }

    @Override
    public String toString() {
        return "ProcessDefinitionModel{" +
                "processId=" + metadata.processId +
                ", processVersion=" + metadata.processVersion +
                '}';
    }
}
