/*
 * Decompiled with CFR 0.152.
 */
package org.lorislab.jel.testcontainers.mockserver;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.google.common.net.MediaType;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.lorislab.jel.testcontainers.mockserver.MockExpectationResponseCallback;
import org.lorislab.jel.testcontainers.mockserver.MockForwardChainExpectation;
import org.mockserver.client.MockServerClient;
import org.mockserver.model.HttpRequest;
import org.mockserver.model.HttpResponse;
import org.mockserver.model.HttpStatusCode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MockServer {
    private static final Logger log = LoggerFactory.getLogger(MockServer.class);
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private static final ObjectWriter OBJECT_WRITER = OBJECT_MAPPER.writer();
    private List<MockForwardChainExpectation> expectations = new ArrayList<MockForwardChainExpectation>();
    private MockServerClient mockServerClient;
    private long timeout;

    public MockServer(MockServerClient mockServerClient) {
        this(mockServerClient, 5L);
    }

    private MockServer(MockServerClient mockServerClient, long timeout) {
        this.mockServerClient = mockServerClient;
        this.timeout = timeout;
    }

    public MockForwardChainExpectation when(HttpRequest request) {
        MockForwardChainExpectation e = new MockForwardChainExpectation(this.mockServerClient.when(request));
        this.expectations.add(e);
        return e;
    }

    public MockExpectationResponseCallback isFinished() {
        for (int i = 0; i < this.expectations.size(); ++i) {
            MockForwardChainExpectation expectation = this.expectations.get(i);
            for (MockExpectationResponseCallback c : expectation.getCallbacks()) {
                CountDownLatch cd = c.getCountDownLatch();
                log.info("Check exception at index: {} name: {} executed: {} expected: {}", new Object[]{i, c.getName(), cd.getCount(), c.getCount()});
                try {
                    log.info("Wait for mock callback '{}' timeout: {}s", (Object)c.getName(), (Object)this.timeout);
                    if (cd.await(this.timeout, TimeUnit.SECONDS)) continue;
                    log.error("Waiting time elapsed before the count at index: {} name: {} executed: {} expected: {}", new Object[]{i, c.getName(), cd.getCount(), c.getCount()});
                    return c;
                }
                catch (InterruptedException ex) {
                    log.error("Interrupted exception at index: {} name: {} executed: {} expected: {}", new Object[]{i, c.getName(), cd.getCount(), c.getCount()});
                    return c;
                }
            }
        }
        return null;
    }

    public static HttpResponse withResponse() {
        return HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.OK_200.code()));
    }

    public static HttpResponse withResponse(String resource) {
        return MockServer.withResponse(resource, HttpStatusCode.OK_200);
    }

    public static HttpResponse withResponse(String resource, HttpStatusCode status) {
        return HttpResponse.response().withBody(MockServer.loadResource(resource), MediaType.JSON_UTF_8).withStatusCode(Integer.valueOf(status.code()));
    }

    public static HttpResponse withResponse(Object data) {
        return MockServer.withResponse(data, HttpStatusCode.OK_200);
    }

    public static HttpResponse withResponse(Object data, HttpStatusCode status) {
        try {
            String body = OBJECT_WRITER.writeValueAsString(data);
            return HttpResponse.response().withBody(body, MediaType.JSON_UTF_8).withStatusCode(Integer.valueOf(status.code()));
        }
        catch (Exception ex) {
            throw new RuntimeException("Error create a mock response body!", ex);
        }
    }

    private static String loadResource(String name) {
        try {
            URL url = MockServer.class.getResource(name);
            if (url != null) {
                Path path = Paths.get(url.toURI());
                return new String(Files.readAllBytes(path));
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        throw new RuntimeException("Missing resource " + name);
    }
}

