/*
 * Decompiled with CFR 0.152.
 */
package org.lorislab.jel.testcontainers.docker;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.lorislab.jel.testcontainers.docker.ContainerConfig;
import org.lorislab.jel.testcontainers.docker.DockerComposeService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.containers.Network;
import org.testcontainers.shaded.org.yaml.snakeyaml.Yaml;

public class DockerTestEnvironment {
    private static final Logger log = LoggerFactory.getLogger(DockerTestEnvironment.class);
    private Map<String, DockerComposeService> containers = new HashMap<String, DockerComposeService>();
    private Map<Integer, List<DockerComposeService>> containerProperties = new HashMap<Integer, List<DockerComposeService>>();
    private Network network;

    public DockerTestEnvironment() {
        this(System.getProperty("test.docker.compose.file", "./src/test/resources/docker-compose.yml"));
    }

    public DockerTestEnvironment(String dockerComposeFile) {
        this.load(new File(dockerComposeFile));
    }

    public DockerComposeService getService(String name) {
        return this.containers.get(name);
    }

    public Network getNetwork() {
        return this.network;
    }

    public void load(File dockerComposeFile) {
        this.network = Network.newNetwork();
        boolean integrationTest = Boolean.getBoolean("test.integration");
        Yaml yaml = new Yaml();
        try (FileInputStream fileInputStream = FileUtils.openInputStream((File)dockerComposeFile);){
            Map map = (Map)yaml.load((InputStream)fileInputStream);
            Object services = map.get("services");
            if (services instanceof Map) {
                Map data = (Map)services;
                data.forEach((k, v) -> {
                    ContainerConfig config = ContainerConfig.createContainerProperties(k, (Map)v);
                    if (integrationTest && config.integrationTest || !integrationTest && config.unitTest) {
                        DockerComposeService service = DockerComposeService.createDockerComposeService(this.network, config);
                        this.containerProperties.computeIfAbsent(service.getConfig().priority, x -> new ArrayList()).add(service);
                        this.containers.put((String)k, service);
                    }
                });
            }
        }
        catch (IOException e) {
            log.warn("Failed to read YAML from {}", (Object)dockerComposeFile.getAbsolutePath(), (Object)e);
        }
    }

    public void start() {
        ArrayList<Integer> priorities = new ArrayList<Integer>(this.containerProperties.keySet());
        Collections.sort(priorities);
        priorities.forEach(p -> {
            List<DockerComposeService> services = this.containerProperties.get(p);
            List names = services.stream().map(DockerComposeService::getName).collect(Collectors.toList());
            log.info("\n------------------------------\nStart test containers\npriority: {}\nServices: {}\n------------------------------", p, names);
            services.parallelStream().forEach(s -> s.start(this));
        });
    }

    public void stop() {
        this.containers.values().parallelStream().forEach(DockerComposeService::stop);
    }
}

