/*
 * Decompiled with CFR 0.152.
 */
package org.lorislab.jel.testcontainers.docker;

import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.lorislab.jel.testcontainers.ContainerLogger;
import org.lorislab.jel.testcontainers.docker.ContainerConfig;
import org.lorislab.jel.testcontainers.docker.DockerTestEnvironment;
import org.lorislab.jel.testcontainers.docker.properties.TestProperty;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.Network;
import org.testcontainers.containers.wait.strategy.Wait;
import org.testcontainers.containers.wait.strategy.WaitStrategy;
import org.testcontainers.images.PullPolicy;
import org.testcontainers.utility.MountableFile;

public class DockerComposeService {
    private static final Logger log = LoggerFactory.getLogger(DockerComposeService.class);
    private GenericContainer<?> container;
    private ContainerConfig config;

    private DockerComposeService(Network network, ContainerConfig config) {
        this.config = config;
        this.container = this.createContainer(network, config);
    }

    public static DockerComposeService createDockerComposeService(Network network, ContainerConfig config) {
        return new DockerComposeService(network, config);
    }

    public String getName() {
        return this.config.name;
    }

    public ContainerConfig getConfig() {
        return this.config;
    }

    public GenericContainer<?> getContainer() {
        return this.container;
    }

    public void start(DockerTestEnvironment environment) {
        if (this.container == null) {
            return;
        }
        Map<String, String> env = DockerComposeService.createValues(environment, this.config.refEnvironments);
        log.info("Service: '{}' add test environment variables: {}", (Object)this.config.name, env);
        this.container.withEnv(env);
        this.container.start();
        Map<String, String> prop = DockerComposeService.createValues(environment, this.config.properties);
        log.info("Service: '{}' update test properties: {}", (Object)this.config.name, prop);
        prop.forEach(System::setProperty);
    }

    private static Map<String, String> createValues(DockerTestEnvironment environment, List<TestProperty> properties) {
        return properties.stream().collect(Collectors.toMap(p -> p.name, p -> p.getValue(environment)));
    }

    public void stop() {
        this.config.properties.forEach(p -> System.clearProperty(p.name));
        this.container.stop();
    }

    public Integer getPort(int port) {
        return DockerComposeService.getPort(this.container, port);
    }

    public static Integer getPort(GenericContainer<?> container, int port) {
        return container.getMappedPort(port);
    }

    public String getHost() {
        return DockerComposeService.getHost(this.container);
    }

    public static String getHost(GenericContainer<?> container) {
        return container.getContainerIpAddress();
    }

    public String getUrl(int port) {
        return DockerComposeService.getUrl(this.container, port);
    }

    public static String getUrl(GenericContainer<?> container, int port) {
        return "http://" + DockerComposeService.getHost(container) + ":" + DockerComposeService.getPort(container, port);
    }

    private GenericContainer<?> createContainer(Network network, ContainerConfig config) {
        try (GenericContainer result = new GenericContainer(config.image);){
            result.withNetwork(network).withNetworkAliases(new String[]{config.name});
            switch (config.imagePull) {
                case ALWAYS: {
                    result.withImagePullPolicy(PullPolicy.alwaysPull());
                    break;
                }
                case MAX_AGE: {
                    result.withImagePullPolicy(PullPolicy.ageBased((Duration)config.imagePullDuration));
                    break;
                }
                case DEFAULT: {
                    result.withImagePullPolicy(PullPolicy.defaultPolicy());
                }
            }
            if (config.waitLogRegex != null) {
                result.waitingFor((WaitStrategy)Wait.forLogMessage((String)config.waitLogRegex, (int)config.waitLogTimes));
            }
            if (config.log) {
                result.withLogConsumer((Consumer)((Object)ContainerLogger.create(config.name)));
            }
            config.environments.forEach((arg_0, arg_1) -> ((GenericContainer)result).withEnv(arg_0, arg_1));
            config.volumes.forEach((k, v) -> {
                String key = k;
                if (key.startsWith("./")) {
                    key = key.substring(1);
                }
                result.withCopyFileToContainer(MountableFile.forClasspathResource((String)key), v);
            });
            config.ports.values().stream().map(Integer::parseInt).forEach(arg_0 -> ((GenericContainer)result).addExposedPort(arg_0));
            GenericContainer genericContainer = result;
            return genericContainer;
        }
    }
}

