/*
 * Decompiled with CFR 0.152.
 */
package org.lorislab.jel.testcontainers.docker;

import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.lorislab.jel.testcontainers.docker.properties.TestProperty;
import org.lorislab.jel.testcontainers.docker.properties.TestPropertyLoader;

public class ContainerConfig {
    public static final Integer DEFAULT_PRIORITY = 100;
    public String name;
    public boolean integrationTest = true;
    public boolean unitTest = true;
    public PullPolicy imagePull = PullPolicy.DEFAULT;
    public Duration imagePullDuration;
    public Integer priority = DEFAULT_PRIORITY;
    public String image;
    public String waitLogRegex;
    public int waitLogTimes = 1;
    public boolean log = true;
    public Map<String, String> environments;
    public Map<String, String> volumes;
    public Map<String, String> ports;
    public List<TestProperty> properties = new ArrayList<TestProperty>();
    public List<TestProperty> refEnvironments = new ArrayList<TestProperty>();

    private ContainerConfig(String name, Map<String, Object> data) {
        this.name = name;
        this.load(data);
    }

    public static ContainerConfig createContainerProperties(String name, Map<String, Object> data) {
        return new ContainerConfig(name, data);
    }

    private void load(Map<String, Object> data) {
        this.image = (String)data.get("image");
        this.environments = ContainerConfig.getMap(data, "environment");
        this.volumes = ContainerConfig.getMapFromList(data, "volumes", ":");
        this.ports = ContainerConfig.getMapFromList(data, "ports", ":");
        Map<String, String> labels = ContainerConfig.getMapFromList(data, "labels", "=");
        if (!labels.isEmpty()) {
            this.integrationTest = ContainerConfig.getLabelBoolean(labels, "test.integration", true);
            this.unitTest = ContainerConfig.getLabelBoolean(labels, "test.unit", true);
            this.imagePull = PullPolicy.valueOf(labels.getOrDefault("test.image.pull", PullPolicy.DEFAULT.name()));
            if (this.imagePull == PullPolicy.MAX_AGE) {
                this.imagePullDuration = Duration.parse(labels.getOrDefault("test.image.pull.max_age", "PT10"));
            }
            this.waitLogRegex = labels.getOrDefault("test.Wait.forLogMessage.regex", null);
            this.waitLogTimes = ContainerConfig.getLabelInteger(labels, "test.Wait.forLogMessage.times", 1);
            this.log = ContainerConfig.getLabelBoolean(labels, "test.Log", true);
            this.priority = ContainerConfig.getLabelInteger(labels, "test.priority", DEFAULT_PRIORITY);
        }
        labels.forEach((k, v) -> {
            if (k.startsWith("test.property")) {
                String key = k.substring("test.property.".length());
                this.properties.add(TestPropertyLoader.createTestProperty(key, v));
            } else if (k.startsWith("test.env.")) {
                String key = k.substring("test.env.".length());
                this.refEnvironments.add(TestPropertyLoader.createTestProperty(key, v));
            }
        });
    }

    private static Map<String, String> getMap(Map<String, Object> properties, String key) {
        Object map = properties.get(key);
        if (map instanceof Map) {
            return (Map)map;
        }
        return Collections.emptyMap();
    }

    private static List<String> getList(Map<String, Object> properties, String key) {
        Object list = properties.get(key);
        if (list instanceof List) {
            return (List)list;
        }
        return Collections.emptyList();
    }

    private static Map<String, String> getMapFromList(Map<String, Object> properties, String key, String regex) {
        List<String> list = ContainerConfig.getList(properties, key);
        if (!list.isEmpty()) {
            return list.stream().map(s -> s.split(regex, 2)).collect(Collectors.toMap(a -> a[0], a -> ((String[])a).length > 1 ? a[1] : ""));
        }
        return Collections.emptyMap();
    }

    private static boolean getLabelBoolean(Map<String, String> labels, String name, boolean defaultValue) {
        return Boolean.parseBoolean(labels.getOrDefault(name, Boolean.toString(defaultValue)));
    }

    private static int getLabelInteger(Map<String, String> labels, String name, int defaultValue) {
        return Integer.parseInt(labels.getOrDefault(name, Integer.toString(defaultValue)));
    }

    public static enum PullPolicy {
        DEFAULT,
        ALWAYS,
        MAX_AGE;

    }
}

