/*
 * Decompiled with CFR 0.152.
 */
package org.lorislab.jel.testcontainers;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InjectLoggerExtension
implements BeforeEachCallback {
    public void beforeEach(ExtensionContext context) throws Exception {
        List<Field> fields = InjectLoggerExtension.getAllLoggerFields(context.getRequiredTestClass());
        for (Field f : fields) {
            f.setAccessible(true);
            f.set(context.getRequiredTestInstance(), LoggerFactory.getLogger(context.getRequiredTestInstance().getClass()));
        }
    }

    private static List<Field> getAllLoggerFields(Class<?> clazz) {
        if (clazz == null) {
            return Collections.emptyList();
        }
        ArrayList<Field> result = new ArrayList<Field>(InjectLoggerExtension.getAllLoggerFields(clazz.getSuperclass()));
        result.addAll(Arrays.stream(clazz.getDeclaredFields()).filter(f -> f.getType().equals(Logger.class)).filter(f -> f.getAnnotation(Inject.class) != null).collect(Collectors.toList()));
        return result;
    }
}

