/*
 * Decompiled with CFR 0.152.
 */
package org.lorislab.jel.testcontainers.mockserver;

import java.util.concurrent.CountDownLatch;
import org.mockserver.mock.action.ExpectationResponseCallback;
import org.mockserver.model.HttpRequest;
import org.mockserver.model.HttpResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MockExpectationResponseCallback
implements ExpectationResponseCallback {
    private static final Logger log = LoggerFactory.getLogger(MockExpectationResponseCallback.class);
    private ExpectationResponseCallback callback;
    private int count;
    private String name;
    private CountDownLatch countDownLatch;

    public MockExpectationResponseCallback(String name, ExpectationResponseCallback callback, int count) {
        this.callback = callback;
        this.count = count;
        this.countDownLatch = new CountDownLatch(count);
        this.name = name;
    }

    public CountDownLatch getCountDownLatch() {
        return this.countDownLatch;
    }

    public String getName() {
        return this.name;
    }

    public int getCount() {
        return this.count;
    }

    public HttpResponse handle(HttpRequest httpRequest) {
        this.countDownLatch.countDown();
        log.info("Wait for execution '{}' executed {}  expected {}", new Object[]{this.name, (long)this.count - this.countDownLatch.getCount(), this.count});
        return this.callback.handle(HttpRequest.request());
    }
}

