/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.service.rest.security.oauth2;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.locationtech.geowave.service.rest.security.oauth2.FacebookAccessTokenConverter;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.oauth2.common.OAuth2AccessToken;
import org.springframework.security.oauth2.common.exceptions.InvalidTokenException;
import org.springframework.security.oauth2.provider.OAuth2Authentication;
import org.springframework.security.oauth2.provider.token.AccessTokenConverter;
import org.springframework.security.oauth2.provider.token.RemoteTokenServices;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.DefaultResponseErrorHandler;
import org.springframework.web.client.ResponseErrorHandler;
import org.springframework.web.client.RestOperations;
import org.springframework.web.client.RestTemplate;

public class FacebookTokenServices
extends RemoteTokenServices {
    protected final Log logger = LogFactory.getLog(((Object)((Object)this)).getClass());
    private RestOperations restTemplate;
    private String checkTokenEndpointUrl;
    private String tokenName = "token";
    private AccessTokenConverter tokenConverter = new FacebookAccessTokenConverter();

    public FacebookTokenServices() {
        this.restTemplate = new RestTemplate();
        ((RestTemplate)this.restTemplate).setErrorHandler((ResponseErrorHandler)new DefaultResponseErrorHandler(){

            public void handleError(ClientHttpResponse response) throws IOException {
                if (response.getRawStatusCode() != 400) {
                    super.handleError(response);
                }
            }
        });
    }

    public void setRestTemplate(RestOperations restTemplate) {
        this.restTemplate = restTemplate;
    }

    public void setCheckTokenEndpointUrl(String checkTokenEndpointUrl) {
        this.checkTokenEndpointUrl = checkTokenEndpointUrl;
    }

    public void setAccessTokenConverter(AccessTokenConverter accessTokenConverter) {
        this.tokenConverter = accessTokenConverter;
    }

    public void setTokenName(String tokenName) {
        this.tokenName = tokenName;
    }

    public OAuth2Authentication loadAuthentication(String accessToken) throws AuthenticationException, InvalidTokenException {
        LinkedMultiValueMap formData = new LinkedMultiValueMap();
        formData.add((Object)this.tokenName, (Object)accessToken);
        HttpHeaders headers = new HttpHeaders();
        String req = "";
        try {
            req = this.checkTokenEndpointUrl + "?access_token=" + URLEncoder.encode(accessToken, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            this.logger.error((Object)"Unsupported encoding", (Throwable)e);
        }
        Map<String, Object> map = this.getForMap(req, (MultiValueMap<String, String>)formData, headers);
        if (map.containsKey("error")) {
            this.logger.debug((Object)("check_token returned error: " + map.get("error")));
            throw new InvalidTokenException(accessToken);
        }
        return this.tokenConverter.extractAuthentication(map);
    }

    public OAuth2AccessToken readAccessToken(String accessToken) {
        throw new UnsupportedOperationException("Not supported: read access token");
    }

    private Map<String, Object> getForMap(String path, MultiValueMap<String, String> formData, HttpHeaders headers) {
        Map map;
        if (headers.getContentType() == null) {
            headers.setContentType(MediaType.APPLICATION_FORM_URLENCODED);
        }
        Map result = map = (Map)this.restTemplate.exchange(path, HttpMethod.GET, new HttpEntity(formData, (MultiValueMap)headers), Map.class, new Object[0]).getBody();
        return result;
    }
}

