/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.service.rest.security.oauth2;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.AuthorityUtils;
import org.springframework.security.oauth2.provider.OAuth2Authentication;
import org.springframework.security.oauth2.provider.OAuth2Request;
import org.springframework.security.oauth2.provider.token.DefaultAccessTokenConverter;
import org.springframework.security.oauth2.provider.token.UserAuthenticationConverter;
import org.springframework.util.StringUtils;

public class FacebookAccessTokenConverter
extends DefaultAccessTokenConverter {
    private Collection<? extends GrantedAuthority> defaultAuthorities;

    public final void setUserTokenConverter(UserAuthenticationConverter userTokenConverter) {
    }

    public void setDefaultAuthorities(String[] defaultAuthorities) {
        this.defaultAuthorities = AuthorityUtils.commaSeparatedStringToAuthorityList((String)StringUtils.arrayToCommaDelimitedString((Object[])defaultAuthorities));
    }

    public OAuth2Authentication extractAuthentication(Map<String, ?> map) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        Set<String> scope = this.parseScopes(map);
        Object principal = map.get("name");
        UsernamePasswordAuthenticationToken user = new UsernamePasswordAuthenticationToken(principal, (Object)"N/A", this.defaultAuthorities);
        String clientId = (String)map.get("client_id");
        parameters.put("client_id", clientId);
        LinkedHashSet resourceIds = new LinkedHashSet(map.containsKey("aud") ? (Collection)map.get("aud") : Collections.emptySet());
        OAuth2Request request = new OAuth2Request(parameters, clientId, null, true, scope, resourceIds, null, null, null);
        return new OAuth2Authentication(request, (Authentication)user);
    }

    private Set<String> parseScopes(Map<String, ?> map) {
        String scopeAsObject = map.containsKey("scope") ? map.get("scope") : "";
        LinkedHashSet<String> scope = new LinkedHashSet<String>();
        if (String.class.isAssignableFrom(scopeAsObject.getClass())) {
            String scopeAsString = scopeAsObject;
            Collections.addAll(scope, scopeAsString.split(","));
        } else if (Collection.class.isAssignableFrom(scopeAsObject.getClass())) {
            Collection scopes = (Collection)((Object)scopeAsObject);
            scope.addAll(scopes);
        }
        return scope;
    }
}

