/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.service.rest.security;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.UUID;
import javax.servlet.ServletContext;
import org.locationtech.geowave.service.rest.security.GeoWaveBaseApiKeyDB;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;

public class GeoWaveSQLiteApiKeyDB
extends GeoWaveBaseApiKeyDB {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = LoggerFactory.getLogger(GeoWaveSQLiteApiKeyDB.class);
    private String dbFileName;
    private String dbPath;

    public GeoWaveSQLiteApiKeyDB() {
    }

    public GeoWaveSQLiteApiKeyDB(String dbFileName) {
        this.dbFileName = dbFileName;
    }

    @Override
    public void initApiKeyDatabase() {
        String url = "jdbc:sqlite:" + this.dbPath + this.dbFileName;
        try (Connection conn = DriverManager.getConnection(url);){
            String sql = "CREATE TABLE IF NOT EXISTS api_keys (\n\tid integer PRIMARY KEY,\n\tapiKey blob NOT NULL,\n\tusername text NOT NULL\n);";
            try (Statement stmnt = conn.createStatement();){
                stmnt.execute("CREATE TABLE IF NOT EXISTS api_keys (\n\tid integer PRIMARY KEY,\n\tapiKey blob NOT NULL,\n\tusername text NOT NULL\n);");
            }
        }
        catch (SQLException e) {
            LOGGER.error("Error SQLException: ", (Object)e.getMessage());
        }
    }

    @Override
    public void setServletContext(ServletContext servletContext) {
        super.setServletContext(servletContext);
        this.dbPath = servletContext.getRealPath("/");
        this.initApiKeyDatabase();
    }

    @Override
    public boolean hasKey(String apiKey) {
        String dbUrl = this.getDbUrl();
        boolean found = false;
        try (Connection conn = DriverManager.getConnection(dbUrl);){
            String sql_query = "SELECT * FROM api_keys WHERE apiKey=?;";
            try (PreparedStatement query_stmnt = conn.prepareStatement("SELECT * FROM api_keys WHERE apiKey=?;");){
                query_stmnt.setString(1, apiKey);
                try (ResultSet rs = query_stmnt.executeQuery();){
                    if (rs.next()) {
                        found = true;
                    }
                }
            }
        }
        catch (SQLException e) {
            LOGGER.error("Error SQLException: ", (Object)e.getMessage());
            return false;
        }
        return found;
    }

    @Override
    public String getCurrentUserAndKey() {
        SecurityContext context = SecurityContextHolder.getContext();
        if (context != null) {
            String userKey;
            block53: {
                String username = context.getAuthentication().getName();
                userKey = "";
                if (username != null) {
                    String dbUrl = this.getDbUrl();
                    try (Connection conn = DriverManager.getConnection(dbUrl);){
                        String sql_query = "SELECT * FROM api_keys WHERE username=?;";
                        try (PreparedStatement query_stmnt = conn.prepareStatement("SELECT * FROM api_keys WHERE username=?;");){
                            query_stmnt.setString(1, username);
                            try (ResultSet rs = query_stmnt.executeQuery();){
                                if (!rs.next()) {
                                    UUID apiKey = UUID.randomUUID();
                                    userKey = username + ":" + apiKey.toString();
                                    String sql = "INSERT INTO api_keys (apiKey, username)\nVALUES(?, ?);";
                                    LOGGER.info("Inserting a new api key and user.");
                                    try (PreparedStatement stmnt = conn.prepareStatement("INSERT INTO api_keys (apiKey, username)\nVALUES(?, ?);");){
                                        stmnt.setString(1, apiKey.toString());
                                        stmnt.setString(2, username);
                                        stmnt.executeUpdate();
                                        break block53;
                                    }
                                }
                                String apiKeyStr = rs.getString("apiKey");
                                userKey = username + ":" + apiKeyStr;
                            }
                        }
                    }
                    catch (SQLException e) {
                        LOGGER.error("Error SQLException: ", (Object)e.getMessage());
                    }
                }
            }
            return userKey;
        }
        return "";
    }

    private String getDbUrl() {
        return "jdbc:sqlite:" + this.dbPath + this.dbFileName;
    }
}

