/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.service.rest.security;

import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.locationtech.geowave.service.rest.security.GeoWaveBaseApiKeyDB;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;
import org.springframework.web.filter.GenericFilterBean;

public class GeoWaveApiKeySetterFilter
extends GenericFilterBean {
    private static final Logger LOGGER = LoggerFactory.getLogger(GeoWaveApiKeySetterFilter.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        try {
            ServletContext servletContext = this.getServletContext();
            WebApplicationContext ac = WebApplicationContextUtils.getWebApplicationContext((ServletContext)servletContext);
            GeoWaveBaseApiKeyDB apiKeyDB = (GeoWaveBaseApiKeyDB)ac.getBean("apiKeyDB");
            String userAndKey = apiKeyDB.getCurrentUserAndKey();
            if (!userAndKey.equals("")) {
                String[] userAndKeyToks = userAndKey.split(":");
                servletContext.setAttribute("userName", (Object)userAndKeyToks[0]);
                servletContext.setAttribute("apiKey", (Object)userAndKeyToks[1]);
            }
        }
        catch (Exception e) {
            return;
        }
        finally {
            chain.doFilter(request, response);
        }
    }
}

