/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.service.rest.security;

import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.locationtech.geowave.service.rest.security.GeoWaveBaseApiKeyDB;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;
import org.springframework.web.filter.GenericFilterBean;

public class GeoWaveApiKeyFilter
extends GenericFilterBean {
    private static final Logger LOGGER = LoggerFactory.getLogger(GeoWaveApiKeyFilter.class);

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        boolean validKeyFound = true;
        try {
            ServletContext servletContext = this.getServletContext();
            WebApplicationContext ac = WebApplicationContextUtils.getWebApplicationContext((ServletContext)servletContext);
            GeoWaveBaseApiKeyDB dbBean = (GeoWaveBaseApiKeyDB)ac.getBean("apiKeyDB");
            String apiKey = request.getParameter("apiKey");
            if (apiKey == null) {
                LOGGER.error("apiKey is null");
                validKeyFound = false;
            } else if (!dbBean.hasKey(apiKey)) {
                LOGGER.error("apiKey is invalid");
                validKeyFound = false;
            }
        }
        catch (Exception e) {
            LOGGER.error("Error: ", (Object)e.getMessage());
        }
        if (!validKeyFound) {
            return;
        }
        chain.doFilter(request, response);
    }
}

