/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.service.rest.operations;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParameterException;
import com.beust.jcommander.Parameters;
import com.beust.jcommander.ParametersDelegate;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.locationtech.geowave.core.cli.api.OperationParams;
import org.locationtech.geowave.core.cli.api.ServiceEnabledCommand;
import org.locationtech.geowave.core.geotime.index.SpatialTemporalOptions;
import org.locationtech.geowave.core.store.api.Index;
import org.locationtech.geowave.core.store.cli.index.IndexSection;
import org.locationtech.geowave.core.store.cli.store.DataStorePluginOptions;
import org.locationtech.geowave.core.store.cli.store.StoreLoader;
import org.locationtech.geowave.core.store.index.IndexPluginOptions;
import org.locationtech.geowave.core.store.index.IndexStore;
import org.locationtech.geowave.core.store.operations.remote.options.BasicIndexOptions;
import org.locationtech.geowave.core.store.spi.DimensionalityTypeOptions;

@Parameters(commandDescription="Add a spatial temporal index to a GeoWave store")
public class AddSpatialTemporalIndexCommand
extends ServiceEnabledCommand<String> {
    @Parameter(description="<store name> <index name>", required=true)
    private List<String> parameters = new ArrayList<String>();
    @ParametersDelegate
    private BasicIndexOptions basicIndexOptions = new BasicIndexOptions();
    private IndexPluginOptions pluginOptions = new IndexPluginOptions();
    @ParametersDelegate
    SpatialTemporalOptions opts = new SpatialTemporalOptions();

    public boolean prepare(OperationParams params) {
        this.pluginOptions.selectPlugin("spatial_temporal");
        this.pluginOptions.setBasicIndexOptions(this.basicIndexOptions);
        this.pluginOptions.setDimensionalityTypeOptions((DimensionalityTypeOptions)this.opts);
        return true;
    }

    public void execute(OperationParams params) throws Exception {
        this.computeResults(params);
    }

    public String getId() {
        return IndexSection.class.getName() + ".add/spatial_temporal";
    }

    public String getPath() {
        return "v0/index/add/spatial_temporal";
    }

    public IndexPluginOptions getPluginOptions() {
        return this.pluginOptions;
    }

    public String getPluginName() {
        return this.parameters.get(0);
    }

    public String getNamespace() {
        return IndexPluginOptions.getIndexNamespace((String)this.getPluginName());
    }

    public List<String> getParameters() {
        return this.parameters;
    }

    public void setParameters(String storeName, String indexName) {
        this.parameters = new ArrayList<String>();
        this.parameters.add(storeName);
        this.parameters.add(indexName);
    }

    public String getType() {
        return "spatial_temporal";
    }

    public void setPluginOptions(IndexPluginOptions pluginOptions) {
        this.pluginOptions = pluginOptions;
    }

    public String computeResults(OperationParams params) throws Exception {
        if (this.getParameters().size() < 2) {
            System.out.println(this.getParameters());
            throw new ParameterException("Must specify store name and index name");
        }
        String storeName = this.getParameters().get(0);
        String indexName = this.getParameters().get(1);
        this.pluginOptions.setName(indexName);
        Index newIndex = this.pluginOptions.createIndex();
        File configFile = this.getGeoWaveConfigFile(params);
        StoreLoader inputStoreLoader = new StoreLoader(storeName);
        if (!inputStoreLoader.loadFromConfig(configFile)) {
            throw new ParameterException("Cannot find store name: " + inputStoreLoader.getStoreName());
        }
        DataStorePluginOptions storeOptions = inputStoreLoader.getDataStorePlugin();
        IndexStore indexStore = storeOptions.createIndexStore();
        Index existingIndex = indexStore.getIndex(newIndex.getName());
        if (existingIndex != null) {
            throw new ParameterException("That index already exists: " + newIndex.getName());
        }
        indexStore.addIndex(newIndex);
        return newIndex.getName();
    }
}

