/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.service.rest.operations;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParameterException;
import com.beust.jcommander.Parameters;
import com.beust.jcommander.ParametersDelegate;
import com.beust.jcommander.internal.Console;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.locationtech.geowave.core.cli.api.OperationParams;
import org.locationtech.geowave.core.cli.api.ServiceEnabledCommand;
import org.locationtech.geowave.core.cli.exceptions.DuplicateEntryException;
import org.locationtech.geowave.core.cli.operations.config.options.ConfigOptions;
import org.locationtech.geowave.core.store.StoreFactoryOptions;
import org.locationtech.geowave.core.store.cli.store.DataStorePluginOptions;
import org.locationtech.geowave.core.store.cli.store.StoreSection;
import org.locationtech.geowave.datastore.kudu.config.KuduRequiredOptions;

@Parameters(commandDescription="Create a store within Geowave")
public class AddKuduStoreCommand
extends ServiceEnabledCommand<String> {
    public static final String PROPERTIES_CONTEXT = "properties";
    @Parameter(description="<name>")
    private List<String> parameters = new ArrayList<String>();
    @Parameter(names={"-d", "--default"}, description="Make this the default store in all operations")
    private Boolean makeDefault;
    private DataStorePluginOptions pluginOptions = new DataStorePluginOptions();
    @ParametersDelegate
    private KuduRequiredOptions requiredOptions;

    public boolean prepare(OperationParams params) {
        this.pluginOptions.selectPlugin("kudu");
        this.pluginOptions.setFactoryOptions((StoreFactoryOptions)this.requiredOptions);
        return true;
    }

    public void execute(OperationParams params) throws Exception {
        this.computeResults(params);
    }

    public String computeResults(OperationParams params) throws Exception {
        File propFile = this.getGeoWaveConfigFile(params);
        Properties existingProps = ConfigOptions.loadProperties((File)propFile);
        if (this.parameters.size() != 1) {
            throw new ParameterException("Must specify store name");
        }
        DataStorePluginOptions existingOptions = new DataStorePluginOptions();
        if (existingOptions.load(existingProps, this.getNamespace())) {
            throw new DuplicateEntryException("That store already exists: " + this.getPluginName());
        }
        this.pluginOptions.save(existingProps, this.getNamespace());
        if (Boolean.TRUE.equals(this.makeDefault)) {
            existingProps.setProperty("storedefault", this.getPluginName());
        }
        ConfigOptions.writeProperties((File)propFile, (Properties)existingProps, (Console)params.getConsole());
        StringBuilder builder = new StringBuilder();
        for (Object key : existingProps.keySet()) {
            String[] split = key.toString().split("\\.");
            if (split.length <= 1 || !split[1].equals(this.parameters.get(0))) continue;
            builder.append(key.toString() + "=" + existingProps.getProperty(key.toString()) + "\n");
        }
        return builder.toString();
    }

    public String getId() {
        return StoreSection.class.getName() + ".add/kudu";
    }

    public String getPath() {
        return "v0/store/add/kudu";
    }

    public DataStorePluginOptions getPluginOptions() {
        return this.pluginOptions;
    }

    public String getPluginName() {
        return this.parameters.get(0);
    }

    public String getNamespace() {
        return DataStorePluginOptions.getStoreNamespace((String)this.getPluginName());
    }

    public List<String> getParameters() {
        return this.parameters;
    }

    public void setParameters(String storeName) {
        this.parameters = new ArrayList<String>();
        this.parameters.add(storeName);
    }

    public Boolean getMakeDefault() {
        return this.makeDefault;
    }

    public void setMakeDefault(Boolean makeDefault) {
        this.makeDefault = makeDefault;
    }

    public String getStoreType() {
        return "kudu";
    }

    public void setPluginOptions(DataStorePluginOptions pluginOptions) {
        this.pluginOptions = pluginOptions;
    }
}

