/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.service.rest.field;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParametersDelegate;
import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.locationtech.geowave.service.rest.GeoWaveOperationServiceWrapper;
import org.locationtech.geowave.service.rest.field.BasicRestField;
import org.locationtech.geowave.service.rest.field.ListMainParam;
import org.locationtech.geowave.service.rest.field.ParameterRestField;
import org.locationtech.geowave.service.rest.field.ParameterRestFieldValue;
import org.locationtech.geowave.service.rest.field.RestField;
import org.locationtech.geowave.service.rest.field.RestFieldValue;
import org.locationtech.geowave.service.rest.field.StringMainParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestFieldFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(GeoWaveOperationServiceWrapper.class);
    private static final BitSet UNESCAPED_CHARS = RestFieldFactory.initUnescapedChars();

    public static List<RestField<?>> createRestFields(Class<?> instanceType) {
        return RestFieldFactory.internalCreateRestFields(null, instanceType, (field, parameter, instance) -> new ParameterRestField(field, parameter), (name, isList, mainParamField, subfieldOrdinal, totalSize, instance) -> new BasicRestField<List>(name, isList ? List.class : String.class, "main parameter", true));
    }

    public static List<RestFieldValue<?>> createRestFieldValues(Object instance) {
        return RestFieldFactory.internalCreateRestFields(instance, instance.getClass(), (field, parameter, i) -> new ParameterRestFieldValue(field, parameter, i), (name, isList, mainParamField, subfieldOrdinal, totalSize, i) -> isList ? new ListMainParam(subfieldOrdinal, totalSize, mainParamField, (RestField<List>)new BasicRestField<List>(name, List.class, "main parameter", true), instance) : new StringMainParam(subfieldOrdinal, totalSize, mainParamField, (RestField<String>)new BasicRestField<String>(name, String.class, "main parameter", true), instance));
    }

    private static <T extends RestField<?>> List<T> internalCreateRestFields(Object instance, Class<?> instanceType, ParameterInitializer<T> parameterInitializer, MainParamInitializer<T> mainParamInitializer) {
        ArrayList<T> retVal = new ArrayList<T>();
        for (Field field : FieldUtils.getFieldsWithAnnotation(instanceType, Parameter.class)) {
            retVal.addAll(RestFieldFactory.internalCreateRestFields(field, field.getAnnotation(Parameter.class), instance, parameterInitializer, mainParamInitializer));
        }
        for (Field field : FieldUtils.getFieldsWithAnnotation(instanceType, ParametersDelegate.class)) {
            try {
                Class<?> delegateInstanceType;
                Object delegateInstance;
                if (instance != null) {
                    field.setAccessible(true);
                    delegateInstance = field.get(instance);
                    if (delegateInstance == null) {
                        delegateInstanceType = field.getType();
                        delegateInstance = delegateInstanceType.newInstance();
                    } else {
                        delegateInstanceType = delegateInstance.getClass();
                        if (delegateInstance instanceof Map) {
                            for (Object mapValueInstance : ((Map)delegateInstance).values()) {
                                Class<?> mapValueInstanceType = mapValueInstance.getClass();
                                retVal.addAll(RestFieldFactory.internalCreateRestFields(mapValueInstance, mapValueInstanceType, parameterInitializer, mainParamInitializer));
                            }
                        }
                    }
                    field.set(instance, delegateInstance);
                } else {
                    delegateInstanceType = field.getType();
                    delegateInstance = null;
                }
                retVal.addAll(RestFieldFactory.internalCreateRestFields(delegateInstance, delegateInstanceType, parameterInitializer, mainParamInitializer));
            }
            catch (IllegalAccessException | InstantiationException e) {
                LOGGER.error("Unable to instantiate field", (Throwable)e);
            }
        }
        return retVal;
    }

    private static <T extends RestField<?>> List<T> internalCreateRestFields(final Field field, Parameter parameter, final Object instance, ParameterInitializer<T> parameterInitializer, final MainParamInitializer<T> mainParamInitializer) {
        String desc = parameter.description();
        if (List.class.isAssignableFrom(field.getType()) && !desc.isEmpty() && desc.matches("(<[a-zA-Z0-9:/\\s]+>\\s*)+")) {
            int currentStartParamIndex;
            int currentEndParamIndex = 0;
            ArrayList<ImmutablePair> individualParams = new ArrayList<ImmutablePair>();
            while ((currentStartParamIndex = desc.indexOf(60, currentEndParamIndex)) >= 0 && currentStartParamIndex < desc.length() - 1) {
                currentEndParamIndex = desc.indexOf(62, currentStartParamIndex + 1);
                String fullName = desc.substring(currentStartParamIndex + 1, currentEndParamIndex).trim();
                if (!fullName.isEmpty()) {
                    if (fullName.startsWith("comma separated list of ")) {
                        individualParams.add(ImmutablePair.of((Object)fullName.substring(24).trim(), (Object)true));
                    } else if (fullName.startsWith("comma delimited ")) {
                        individualParams.add(ImmutablePair.of((Object)fullName.substring(16).trim(), (Object)true));
                    } else {
                        individualParams.add(ImmutablePair.of((Object)fullName, (Object)false));
                    }
                }
                if (currentEndParamIndex > 0 && currentEndParamIndex < desc.length()) continue;
            }
            final int totalSize = individualParams.size();
            return Lists.transform(individualParams, (Function)new Function<Pair<String, Boolean>, T>(){
                int i = 0;

                public T apply(Pair<String, Boolean> input) {
                    if (input != null) {
                        return mainParamInitializer.apply(RestFieldFactory.toURLFriendlyString((String)input.getLeft()), (Boolean)input.getRight(), field, this.i++, totalSize, instance);
                    }
                    return null;
                }
            });
        }
        return Collections.singletonList(parameterInitializer.apply(field, parameter, instance));
    }

    public static String toURLFriendlyString(String str) {
        boolean needToChange = false;
        StringBuffer out = new StringBuffer(str.length());
        boolean capsNext = false;
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (UNESCAPED_CHARS.get(c)) {
                if (capsNext) {
                    out.append(Character.toUpperCase(c));
                    capsNext = false;
                    continue;
                }
                out.append(c);
                continue;
            }
            needToChange = true;
            capsNext = true;
        }
        return needToChange ? out.toString() : str;
    }

    private static BitSet initUnescapedChars() {
        int i;
        BitSet unescapedChars = new BitSet(256);
        for (i = 97; i <= 122; ++i) {
            unescapedChars.set(i);
        }
        for (i = 65; i <= 90; ++i) {
            unescapedChars.set(i);
        }
        for (i = 48; i <= 57; ++i) {
            unescapedChars.set(i);
            unescapedChars.set(45);
            unescapedChars.set(95);
            unescapedChars.set(46);
            unescapedChars.set(42);
        }
        return unescapedChars;
    }

    @FunctionalInterface
    private static interface MainParamInitializer<T extends RestField<?>> {
        public T apply(String var1, boolean var2, Field var3, int var4, int var5, Object var6);
    }

    @FunctionalInterface
    private static interface ParameterInitializer<T extends RestField<?>> {
        public T apply(Field var1, Parameter var2, Object var3);
    }
}

