/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.service.rest;

import com.beust.jcommander.Parameters;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.List;
import org.locationtech.geowave.core.cli.api.ServiceEnabledCommand;
import org.locationtech.geowave.service.rest.field.RestField;
import org.locationtech.geowave.service.rest.field.RestFieldFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SwaggerOperationParser<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(SwaggerOperationParser.class);
    private final ServiceEnabledCommand<T> operation;
    private JsonObject json_obj = null;

    public JsonObject getJsonObject() {
        return this.json_obj;
    }

    public SwaggerOperationParser(ServiceEnabledCommand<T> op) {
        this.operation = op;
        this.json_obj = this.parseParameters();
    }

    public JsonObject[] processField(String name, Class<?> type, String description, boolean required) {
        JsonObject param_json = new JsonObject();
        param_json.addProperty("in", "query");
        String swaggerType = this.getSwaggerType(type);
        String typeInfoForDescription = "";
        if (swaggerType == "array") {
            param_json.addProperty("type", swaggerType);
            JsonObject items_json = new JsonObject();
            items_json.addProperty("type", this.getSwaggerType(type.getComponentType()));
            param_json.add("items", (JsonElement)items_json);
        } else if (swaggerType == "enum") {
            param_json.addProperty("type", "string");
        } else {
            param_json.addProperty("type", swaggerType);
        }
        if (!description.isEmpty()) {
            String desc = description + "";
            param_json.addProperty("description", desc);
        }
        param_json.addProperty("name", name);
        param_json.addProperty("required", Boolean.valueOf(required));
        return new JsonObject[]{param_json};
    }

    private JsonObject parseParameters() {
        JsonObject op_json = new JsonObject();
        String opId = this.operation.getId();
        op_json.addProperty("operationId", opId);
        Parameters command_annotation = this.operation.getClass().getAnnotation(Parameters.class);
        op_json.addProperty("description", command_annotation.commandDescription());
        JsonArray fields_obj = new JsonArray();
        List<RestField<?>> fields = RestFieldFactory.createRestFields(this.operation.getClass());
        for (RestField<?> field : fields) {
            JsonObject[] field_obj_array = this.processField(field.getName(), field.getType(), field.getDescription(), field.isRequired());
            if (field_obj_array == null) continue;
            for (JsonObject field_obj : field_obj_array) {
                fields_obj.add((JsonElement)field_obj);
            }
        }
        op_json.add("parameters", (JsonElement)fields_obj);
        JsonObject resp_json = new JsonObject();
        JsonObject codes_json = new JsonObject();
        codes_json.addProperty("description", "success");
        resp_json.add("200", (JsonElement)codes_json);
        codes_json = new JsonObject();
        codes_json.addProperty("description", "route not found");
        resp_json.add("404", (JsonElement)codes_json);
        codes_json = new JsonObject();
        codes_json.addProperty("description", "invalid or null parameter");
        resp_json.add("500", (JsonElement)codes_json);
        op_json.add("responses", (JsonElement)resp_json);
        return op_json;
    }

    private String getSwaggerType(Class<?> type) {
        if (type == String.class) {
            return "string";
        }
        if (type == Integer.class || type == Integer.TYPE) {
            return "integer";
        }
        if (type == Long.TYPE || type == Long.class) {
            return "long";
        }
        if (type == Float.class || type == Float.TYPE) {
            return "number";
        }
        if (type == Boolean.class || type == Boolean.TYPE) {
            return "boolean";
        }
        if (type != null && type.isEnum()) {
            return "enum";
        }
        if (type == List.class || type != null && type.isArray()) {
            return "array";
        }
        return "string";
    }
}

