/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.service.rest;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import org.locationtech.geowave.core.cli.api.ServiceEnabledCommand;
import org.locationtech.geowave.service.rest.RestRoute;
import org.locationtech.geowave.service.rest.SwaggerOperationParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SwaggerApiParser {
    private static final Logger LOGGER = LoggerFactory.getLogger(SwaggerApiParser.class);
    private final JsonObject routesJson = new JsonObject();
    private final String swaggerHeader;
    private final String fileUpload;

    public SwaggerApiParser(String host, String path, String apiVersion, String apiTitle, String apiDescription) {
        this.swaggerHeader = "{\"swagger\": \"2.0\",\"info\": {\"version\": \"" + apiVersion + "\",\"title\": \"" + apiTitle + "\",\"description\": \"" + apiDescription + "\",\"termsOfService\": \"https://github.com/locationtech/geowave\",\"contact\": {\"name\": \"GeoWave Team\"},\"license\": {\"name\": \"Apache2\"}},\"host\": \"" + host + "\",\"basePath\": \"" + path + "\",\"schemes\": [\"http\"],\"consumes\": [\"application/json\",\"multipart/form-data\"],\"produces\": [\"application/json\"],\"paths\":";
        this.fileUpload = ",\"/v0/fileupload\": {\"post\":{\"operationId\": \"fileupload\",\"consumes\": [\"multipart/form-data\"],\"description\": \"Get the version of GeoWave running on the instance of a remote datastore\",\"parameters\": [{\"name\": \"body\",\"description\": \"file detail\",\"required\": false,\"type\": \"file\",\"paramType\": \"body\",\"in\": \"formData\",\"allowMultiple\": false\t}],\t\"responses\": {\t\t\"200\": {\t\"description\": \"success\"\t},\"404\": {\t\"description\": \"route not found\"},\"500\": {\t\"description\": \"invalid or null parameter\"}\t},\"tags\": [\"fileupload\"]}}}";
    }

    public void addRoute(RestRoute route) {
        ServiceEnabledCommand<?> instance = route.getOperation();
        LOGGER.info("OPERATION: " + route.getPath() + " : " + instance.getClass().getName());
        SwaggerOperationParser parser = new SwaggerOperationParser(instance);
        JsonObject op_json = parser.getJsonObject();
        JsonObject method_json = new JsonObject();
        String method = instance.getMethod().toString();
        JsonArray tags_json = new JsonArray();
        String[] path_toks = route.getPath().split("/");
        JsonPrimitive tag = new JsonPrimitive(path_toks[1]);
        tags_json.add((JsonElement)tag);
        op_json.add("tags", (JsonElement)tags_json);
        method_json.add(method.toLowerCase(), (JsonElement)op_json);
        this.routesJson.add("/" + route.getPath(), (JsonElement)method_json);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean serializeSwaggerJson(String filename) {
        OutputStreamWriter writer = null;
        try {
            writer = new OutputStreamWriter((OutputStream)new FileOutputStream(filename), "UTF-8");
        }
        catch (IOException e) {
            LOGGER.warn("Unable to write swagger json", (Throwable)e);
        }
        if (writer == null) {
            return false;
        }
        Gson gson = new GsonBuilder().create();
        try {
            writer.write(this.swaggerHeader);
            StringWriter strWriter = new StringWriter();
            gson.toJson((JsonElement)this.routesJson, (Appendable)strWriter);
            strWriter.getBuffer().deleteCharAt(strWriter.getBuffer().length() - 1);
            writer.write(strWriter.getBuffer().toString());
            writer.write(this.fileUpload);
            ((Writer)writer).write(125);
            ((Writer)writer).close();
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        finally {
            SwaggerApiParser.safeClose(writer);
        }
        return true;
    }

    public static void safeClose(Writer writer) {
        if (writer != null) {
            try {
                writer.close();
            }
            catch (IOException e) {
                LOGGER.warn("Unable to close Writer", (Throwable)e);
            }
        }
    }
}

