/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.service.rest;

import java.util.ArrayList;
import javax.servlet.ServletContext;
import org.locationtech.geowave.service.rest.RestRoute;
import org.restlet.resource.Get;
import org.restlet.resource.ServerResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MainResource
extends ServerResource {
    private static final Logger LOGGER = LoggerFactory.getLogger(MainResource.class);

    @Get(value="html")
    public String listResources() {
        String output = "";
        try {
            StringBuilder routeStringBuilder = new StringBuilder();
            ServletContext servletContext = (ServletContext)this.getContext().getAttributes().get("org.restlet.ext.servlet.ServletContext");
            String userName = (String)servletContext.getAttribute("userName");
            String apiKey = (String)servletContext.getAttribute("apiKey");
            ArrayList availableRoutes = (ArrayList)this.getContext().getAttributes().get("availableRoutes");
            routeStringBuilder.append("Available Routes:<br>");
            for (RestRoute route : availableRoutes) {
                routeStringBuilder.append(route.getPath() + " --> " + route.getOperation() + "<br>");
            }
            output = userName != null && !userName.equals("") ? "<b>Welcome " + userName + "!</b><br><b>API key:</b> " + apiKey + "<br><br>" + routeStringBuilder.toString() : routeStringBuilder.toString();
        }
        catch (Exception e) {
            LOGGER.error("Error listing resources", (Throwable)e);
        }
        return output;
    }

    public static class NonResourceCommand
    extends ServerResource {
        @Get(value="html")
        public String toString() {
            return "The route exists, but the command does not extend ServerResource";
        }
    }
}

