/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.service.rest;

import com.beust.jcommander.IStringConverter;
import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParameterException;
import com.beust.jcommander.converters.NoConverter;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import javax.ws.rs.ForbiddenException;
import javax.ws.rs.NotAuthorizedException;
import org.locationtech.geowave.core.cli.api.OperationParams;
import org.locationtech.geowave.core.cli.api.ServiceEnabledCommand;
import org.locationtech.geowave.core.cli.exceptions.DuplicateEntryException;
import org.locationtech.geowave.core.cli.exceptions.TargetNotFoundException;
import org.locationtech.geowave.core.cli.operations.config.options.ConfigOptions;
import org.locationtech.geowave.core.cli.parser.ManualOperationParams;
import org.locationtech.geowave.service.rest.exceptions.MissingArgumentException;
import org.locationtech.geowave.service.rest.field.RequestParameters;
import org.locationtech.geowave.service.rest.field.RequestParametersForm;
import org.locationtech.geowave.service.rest.field.RequestParametersJson;
import org.locationtech.geowave.service.rest.field.RestFieldFactory;
import org.locationtech.geowave.service.rest.field.RestFieldValue;
import org.locationtech.geowave.service.rest.operations.RestOperationStatusMessage;
import org.restlet.Application;
import org.restlet.Context;
import org.restlet.data.Form;
import org.restlet.data.MediaType;
import org.restlet.data.Metadata;
import org.restlet.data.Status;
import org.restlet.ext.jackson.JacksonRepresentation;
import org.restlet.representation.Representation;
import org.restlet.resource.Delete;
import org.restlet.resource.Get;
import org.restlet.resource.Patch;
import org.restlet.resource.Post;
import org.restlet.resource.Put;
import org.restlet.resource.ServerResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GeoWaveOperationServiceWrapper<T>
extends ServerResource {
    private static final Logger LOGGER = LoggerFactory.getLogger(GeoWaveOperationServiceWrapper.class);
    private final ServiceEnabledCommand<T> operation;
    private final String initContextConfigFile;

    public GeoWaveOperationServiceWrapper(ServiceEnabledCommand<T> operation, String initContextConfigFile) {
        this.operation = operation;
        this.initContextConfigFile = initContextConfigFile;
    }

    @Get(value="json")
    public Representation restGet() throws Exception {
        if (ServiceEnabledCommand.HttpMethod.GET.equals((Object)this.operation.getMethod())) {
            return this.handleRequest(new RequestParametersForm(this.getQuery()));
        }
        this.setStatus(Status.CLIENT_ERROR_METHOD_NOT_ALLOWED);
        return null;
    }

    @Post(value="form|json:json")
    public Representation restPost(Representation request) throws Exception {
        return this.handleRequestWithPayload(ServiceEnabledCommand.HttpMethod.POST, request);
    }

    @Delete(value="form|json:json")
    public Representation restDelete(Representation request) throws Exception {
        return this.handleRequestWithPayload(ServiceEnabledCommand.HttpMethod.DELETE, request);
    }

    @Patch(value="form|json:json")
    public Representation restPatch(Representation request) throws Exception {
        return this.handleRequestWithPayload(ServiceEnabledCommand.HttpMethod.PATCH, request);
    }

    @Put(value="form|json:json")
    public Representation restPut(Representation request) throws Exception {
        return this.handleRequestWithPayload(ServiceEnabledCommand.HttpMethod.PUT, request);
    }

    private Representation handleRequestWithPayload(ServiceEnabledCommand.HttpMethod requiredMethod, Representation request) {
        if (requiredMethod.equals((Object)this.operation.getMethod())) {
            RequestParameters requestParameters;
            if (this.checkMediaType(MediaType.APPLICATION_JSON, request)) {
                try {
                    requestParameters = new RequestParametersJson(request);
                }
                catch (IOException e) {
                    this.setStatus(Status.SERVER_ERROR_INTERNAL);
                    return null;
                }
            } else {
                requestParameters = this.checkMediaType(MediaType.APPLICATION_WWW_FORM, request) ? new RequestParametersForm(new Form(request)) : new RequestParametersForm(this.getQuery());
            }
            return this.handleRequest(requestParameters);
        }
        this.setStatus(Status.CLIENT_ERROR_METHOD_NOT_ALLOWED);
        return null;
    }

    private void injectParameters(RequestParameters requestParameters, Object instance) throws MissingArgumentException, InstantiationException, IllegalAccessException {
        List<RestFieldValue<?>> fields = RestFieldFactory.createRestFieldValues(instance);
        for (RestFieldValue<?> f : fields) {
            Class converter;
            Object objValue = null;
            Class type = f.getType();
            Field field = f.getField();
            String strValue = requestParameters.getString(f.getName());
            if (field.isAnnotationPresent(Parameter.class) && (converter = field.getAnnotation(Parameter.class).converter()) != null && converter != NoConverter.class && strValue != null) {
                try {
                    objValue = ((IStringConverter)converter.newInstance()).convert(strValue);
                }
                catch (InstantiationException e) {
                    LOGGER.warn("Cannot convert parameter since converter does not have zero argument constructor");
                }
            }
            if (objValue == null) {
                if (List.class.isAssignableFrom(type)) {
                    objValue = requestParameters.getList(f.getName());
                } else if (type.isArray()) {
                    objValue = requestParameters.getArray(f.getName());
                    if (objValue != null) {
                        objValue = Arrays.copyOf(objValue, ((Object[])objValue).length, f.getType());
                    }
                } else if (strValue != null) {
                    if (Long.class.isAssignableFrom(type) || Long.TYPE.isAssignableFrom(type)) {
                        objValue = Long.valueOf(strValue);
                    } else if (Integer.class.isAssignableFrom(type) || Integer.TYPE.isAssignableFrom(type)) {
                        objValue = Integer.valueOf(strValue);
                    } else if (Short.class.isAssignableFrom(type) || Short.TYPE.isAssignableFrom(type)) {
                        objValue = Short.valueOf(strValue);
                    } else if (Byte.class.isAssignableFrom(type) || Byte.TYPE.isAssignableFrom(type)) {
                        objValue = Byte.valueOf(strValue);
                    } else if (Double.class.isAssignableFrom(type) || Double.TYPE.isAssignableFrom(type)) {
                        objValue = Double.valueOf(strValue);
                    } else if (Float.class.isAssignableFrom(type) || Float.TYPE.isAssignableFrom(type)) {
                        objValue = Float.valueOf(strValue);
                    } else if (Boolean.class.isAssignableFrom(type) || Boolean.TYPE.isAssignableFrom(type)) {
                        objValue = Boolean.valueOf(strValue);
                    } else if (String.class.isAssignableFrom(type)) {
                        objValue = strValue;
                    } else if (Enum.class.isAssignableFrom(type)) {
                        objValue = Enum.valueOf(type, strValue.toUpperCase());
                    } else {
                        throw new RuntimeException("Unsupported format on field " + f.getType());
                    }
                }
            }
            if (objValue != null) {
                f.setValue(objValue);
                continue;
            }
            if (!f.isRequired()) continue;
            throw new MissingArgumentException(f.getName());
        }
    }

    private Representation handleRequest(RequestParameters parameters) {
        String configFileParameter;
        String string = configFileParameter = parameters == null ? this.getQueryValue("config_file") : (String)parameters.getValue("config_file");
        File configFile = configFileParameter != null ? new File(configFileParameter) : (this.initContextConfigFile != null ? new File(this.initContextConfigFile) : ConfigOptions.getDefaultPropertyFile());
        ManualOperationParams params = new ManualOperationParams();
        params.getContext().put("properties-file", configFile);
        try {
            this.injectParameters(parameters, this.operation);
        }
        catch (Exception e) {
            LOGGER.error("Could not convert parameters", (Throwable)e);
            this.setStatus(Status.CLIENT_ERROR_BAD_REQUEST, e);
            RestOperationStatusMessage rm = new RestOperationStatusMessage();
            rm.status = RestOperationStatusMessage.StatusType.ERROR;
            rm.message = "exception occurred";
            rm.data = e;
            JacksonRepresentation rep = new JacksonRepresentation((Object)rm);
            return rep;
        }
        try {
            this.operation.prepare((OperationParams)params);
            try {
                this.injectParameters(parameters, this.operation);
            }
            catch (Exception e) {
                LOGGER.error("Entered an error handling a request.", (Object)e.getMessage());
                this.setStatus(Status.CLIENT_ERROR_BAD_REQUEST, e);
                RestOperationStatusMessage rm = new RestOperationStatusMessage();
                rm.status = RestOperationStatusMessage.StatusType.ERROR;
                rm.message = "exception occurred";
                rm.data = e;
                JacksonRepresentation rep = new JacksonRepresentation((Object)rm);
                return rep;
            }
            RestOperationStatusMessage rm = new RestOperationStatusMessage();
            if (this.operation.runAsync()) {
                Context appContext = Application.getCurrent().getContext();
                ExecutorService opPool = (ExecutorService)appContext.getAttributes().get("asyncOperationPool");
                ConcurrentHashMap opStatuses = (ConcurrentHashMap)appContext.getAttributes().get("asyncOperationStatuses");
                Callable<Object> task = () -> this.lambda$handleRequest$0((OperationParams)params);
                Future<Object> futureResult = opPool.submit(task);
                UUID opId = UUID.randomUUID();
                opStatuses.put(opId.toString(), futureResult);
                rm.status = RestOperationStatusMessage.StatusType.STARTED;
                rm.message = "Async operation started with ID in data field. Check status at /operation_status?id=";
                rm.data = opId.toString();
            } else {
                Object result = this.operation.computeResults((OperationParams)params);
                rm.status = RestOperationStatusMessage.StatusType.COMPLETE;
                rm.data = result;
            }
            JacksonRepresentation rep = new JacksonRepresentation((Object)rm);
            if (this.operation.successStatusIs200().booleanValue()) {
                this.setStatus(Status.SUCCESS_OK);
            } else {
                this.setStatus(Status.SUCCESS_CREATED);
            }
            return rep;
        }
        catch (NotAuthorizedException e) {
            LOGGER.error("Entered an error handling a request.", (Throwable)e);
            RestOperationStatusMessage rm = new RestOperationStatusMessage();
            rm.status = RestOperationStatusMessage.StatusType.ERROR;
            rm.message = e.getMessage();
            this.setStatus(Status.CLIENT_ERROR_UNAUTHORIZED);
            JacksonRepresentation rep = new JacksonRepresentation((Object)rm);
            return rep;
        }
        catch (ForbiddenException e) {
            LOGGER.error("Entered an error handling a request.", (Throwable)e);
            RestOperationStatusMessage rm = new RestOperationStatusMessage();
            rm.status = RestOperationStatusMessage.StatusType.ERROR;
            rm.message = e.getMessage();
            this.setStatus(Status.CLIENT_ERROR_FORBIDDEN);
            JacksonRepresentation rep = new JacksonRepresentation((Object)rm);
            return rep;
        }
        catch (TargetNotFoundException e) {
            LOGGER.error("Entered an error handling a request.", (Throwable)e);
            RestOperationStatusMessage rm = new RestOperationStatusMessage();
            rm.status = RestOperationStatusMessage.StatusType.ERROR;
            rm.message = e.getMessage();
            this.setStatus(Status.CLIENT_ERROR_NOT_FOUND);
            JacksonRepresentation rep = new JacksonRepresentation((Object)rm);
            return rep;
        }
        catch (ParameterException | DuplicateEntryException e) {
            LOGGER.error("Entered an error handling a request.", e);
            RestOperationStatusMessage rm = new RestOperationStatusMessage();
            rm.status = RestOperationStatusMessage.StatusType.ERROR;
            rm.message = e.getMessage();
            this.setStatus(Status.CLIENT_ERROR_BAD_REQUEST);
            JacksonRepresentation rep = new JacksonRepresentation((Object)rm);
            return rep;
        }
        catch (Exception e) {
            LOGGER.error("Entered an error handling a request.", (Throwable)e);
            RestOperationStatusMessage rm = new RestOperationStatusMessage();
            rm.status = RestOperationStatusMessage.StatusType.ERROR;
            rm.message = "exception occurred";
            rm.data = e;
            this.setStatus(Status.SERVER_ERROR_INTERNAL);
            JacksonRepresentation rep = new JacksonRepresentation((Object)rm);
            return rep;
        }
    }

    private boolean checkMediaType(MediaType expectedType, Representation request) {
        if (request == null) {
            return false;
        }
        return expectedType.isCompatible((Metadata)request.getMediaType());
    }

    private /* synthetic */ Object lambda$handleRequest$0(OperationParams params) throws Exception {
        Object res = this.operation.computeResults(params);
        return res;
    }
}

