/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.service.rest;

import com.beust.jcommander.ParameterException;
import java.io.File;
import java.io.InputStream;
import java.util.List;
import java.util.UUID;
import javax.ws.rs.BadRequestException;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.locationtech.geowave.service.rest.AsyncOperationStatusResource;
import org.locationtech.geowave.service.rest.operations.RestOperationStatusMessage;
import org.restlet.data.MediaType;
import org.restlet.data.Status;
import org.restlet.ext.fileupload.RestletFileUpload;
import org.restlet.ext.jackson.JacksonRepresentation;
import org.restlet.representation.Representation;
import org.restlet.resource.Post;
import org.restlet.resource.ResourceException;
import org.restlet.resource.ServerResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileUploadResource
extends ServerResource {
    private static final Logger LOGGER = LoggerFactory.getLogger(AsyncOperationStatusResource.class);
    private static final String KEY_BATCH_UUID = "batchUUID";

    @Post
    public Representation accept(Representation entity) throws Exception {
        RestOperationStatusMessage status = new RestOperationStatusMessage();
        try {
            List fileList;
            if (this.isMediaType(entity, MediaType.MULTIPART_FORM_DATA)) {
                DiskFileItemFactory factory = new DiskFileItemFactory();
                factory.setSizeThreshold(Integer.MAX_VALUE);
                RestletFileUpload upload = new RestletFileUpload((FileItemFactory)factory);
                fileList = upload.parseRepresentation(entity);
                if (fileList.size() != 1) {
                    throw new ParameterException("Operation requires exactly one file.");
                }
            } else {
                throw new BadRequestException("Operation only supports Multipart Form Data media type.");
            }
            FileItem item = (FileItem)fileList.get(0);
            String tempDir = System.getProperty("java.io.tmpdir");
            File dir = new File(tempDir);
            File filename = File.createTempFile("uploadedfile-", "-" + item.getName(), dir);
            FileUtils.copyInputStreamToFile((InputStream)item.getInputStream(), (File)filename);
            status.status = RestOperationStatusMessage.StatusType.COMPLETE;
            status.message = "File uploaded to: " + filename.getAbsolutePath();
            this.setStatus(Status.SUCCESS_CREATED);
        }
        catch (ParameterException e) {
            LOGGER.error("Entered an error handling a request.", (Throwable)e);
            RestOperationStatusMessage rm = new RestOperationStatusMessage();
            rm.status = RestOperationStatusMessage.StatusType.ERROR;
            rm.message = e.getMessage();
            this.setStatus(Status.CLIENT_ERROR_BAD_REQUEST);
            JacksonRepresentation rep = new JacksonRepresentation((Object)rm);
            return rep;
        }
        catch (BadRequestException e) {
            LOGGER.error("Entered an error handling a request.", (Throwable)e);
            RestOperationStatusMessage rm = new RestOperationStatusMessage();
            rm.status = RestOperationStatusMessage.StatusType.ERROR;
            rm.message = e.getMessage();
            this.setStatus(Status.CLIENT_ERROR_UNSUPPORTED_MEDIA_TYPE);
            JacksonRepresentation rep = new JacksonRepresentation((Object)rm);
            return rep;
        }
        catch (Exception e) {
            LOGGER.error("Entered an error handling a request.", (Throwable)e);
            RestOperationStatusMessage rm = new RestOperationStatusMessage();
            rm.status = RestOperationStatusMessage.StatusType.ERROR;
            rm.message = "exception occurred";
            rm.data = e;
            this.setStatus(Status.SERVER_ERROR_INTERNAL);
            JacksonRepresentation rep = new JacksonRepresentation((Object)rm);
            return rep;
        }
        return new JacksonRepresentation((Object)status);
    }

    private boolean isMediaType(Representation entity, MediaType desiredType) {
        if (entity == null) {
            return false;
        }
        return desiredType.equals((Object)entity.getMediaType(), true);
    }

    private String createBatchDirname() {
        UUID uuid;
        String provided = StringUtils.trimToEmpty((String)this.getQueryValue(KEY_BATCH_UUID));
        if (provided.isEmpty()) {
            uuid = UUID.randomUUID();
        } else {
            try {
                uuid = UUID.fromString(provided);
            }
            catch (IllegalArgumentException e) {
                throw new ResourceException(Status.CLIENT_ERROR_BAD_REQUEST, String.format("'%s' must be a valid UUID", KEY_BATCH_UUID));
            }
        }
        return String.format("upload-batch.%s", uuid);
    }
}

