/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.service.rest;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Future;
import org.locationtech.geowave.service.rest.operations.RestOperationStatusMessage;
import org.restlet.ext.jackson.JacksonRepresentation;
import org.restlet.representation.Representation;
import org.restlet.resource.Get;
import org.restlet.resource.ServerResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsyncOperationStatusResource
extends ServerResource {
    private static final Logger LOGGER = LoggerFactory.getLogger(AsyncOperationStatusResource.class);

    @Get(value="json")
    public Representation getStatus(Representation request) {
        RestOperationStatusMessage status = new RestOperationStatusMessage();
        ConcurrentHashMap opStatuses = null;
        String id = this.getQueryValue("id");
        try {
            opStatuses = (ConcurrentHashMap)this.getApplication().getContext().getAttributes().get("asyncOperationStatuses");
            if (opStatuses.get(id) != null) {
                Future future = (Future)opStatuses.get(id);
                if (future.isDone()) {
                    status.status = RestOperationStatusMessage.StatusType.COMPLETE;
                    status.message = "operation success";
                    status.data = future.get();
                    opStatuses.remove(id);
                } else {
                    status.status = RestOperationStatusMessage.StatusType.RUNNING;
                }
                return new JacksonRepresentation((Object)status);
            }
        }
        catch (Exception e) {
            LOGGER.error("Error exception: ", (Throwable)e);
            status.status = RestOperationStatusMessage.StatusType.ERROR;
            status.message = "exception occurred";
            status.data = e;
            if (opStatuses != null) {
                opStatuses.remove(id);
            }
            return new JacksonRepresentation((Object)status);
        }
        status.status = RestOperationStatusMessage.StatusType.ERROR;
        status.message = "no operation found for ID: " + id;
        return new JacksonRepresentation((Object)status);
    }
}

