/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.service.rest;

import java.lang.management.ManagementFactory;
import java.lang.reflect.Modifier;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.logging.Level;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.Query;
import javax.management.QueryExp;
import javax.servlet.ServletContext;
import org.locationtech.geowave.core.cli.VersionUtils;
import org.locationtech.geowave.core.cli.api.ServiceEnabledCommand;
import org.locationtech.geowave.service.rest.AsyncOperationStatusResource;
import org.locationtech.geowave.service.rest.FileUploadResource;
import org.locationtech.geowave.service.rest.GeoWaveOperationFinder;
import org.locationtech.geowave.service.rest.MainResource;
import org.locationtech.geowave.service.rest.RestRoute;
import org.locationtech.geowave.service.rest.SwaggerApiParser;
import org.locationtech.geowave.service.rest.SwaggerResource;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;
import org.restlet.Application;
import org.restlet.Restlet;
import org.restlet.routing.Router;
import org.restlet.service.CorsService;
import org.restlet.service.Service;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApiRestletApplication
extends Application {
    private static final Logger LOGGER = LoggerFactory.getLogger(ApiRestletApplication.class);
    private ArrayList<RestRoute> availableRoutes = null;
    private final ExecutorService asyncOperationPool = Executors.newFixedThreadPool(10);
    private final ConcurrentHashMap<String, Future> asyncOperationStatuses = new ConcurrentHashMap();

    public ApiRestletApplication() {
        this.parseOperationsForApiRoutes();
        CorsService corsService = new CorsService();
        corsService.setAllowedOrigins(new HashSet<String>(Arrays.asList("*")));
        corsService.setAllowedCredentials(true);
        this.getServices().add((Service)corsService);
    }

    public synchronized Restlet createInboundRoot() {
        Router router = new Router(this.getContext());
        this.getContext().getAttributes().put("availableRoutes", this.availableRoutes);
        this.getContext().getAttributes().put("asyncOperationPool", this.asyncOperationPool);
        this.getContext().getAttributes().put("asyncOperationStatuses", this.asyncOperationStatuses);
        router.attachDefault(MainResource.class);
        router.attach("/api", SwaggerResource.class);
        router.attach("/v0/fileupload", FileUploadResource.class);
        router.attach("/v0/operation_status", AsyncOperationStatusResource.class);
        this.attachApiRoutes(router);
        return router;
    }

    public void parseOperationsForApiRoutes() {
        this.availableRoutes = new ArrayList();
        for (Class operation : new Reflections("org.locationtech.geowave", new Scanner[0]).getSubTypesOf(ServiceEnabledCommand.class)) {
            try {
                if (Modifier.isAbstract(operation.getModifiers())) continue;
                this.availableRoutes.add(new RestRoute((ServiceEnabledCommand)operation.newInstance()));
            }
            catch (IllegalAccessException | InstantiationException e) {
                this.getLogger().log(Level.SEVERE, "Unable to instantiate Service Resource", e);
            }
        }
        Collections.sort(this.availableRoutes);
    }

    public void attachApiRoutes(Router router) {
        ServletContext servlet = (ServletContext)router.getContext().getAttributes().get("org.restlet.ext.servlet.ServletContext");
        String apiHostPort = servlet.getInitParameter("host_port");
        if (apiHostPort == null) {
            try {
                apiHostPort = ApiRestletApplication.getHTTPEndPoint();
            }
            catch (Exception e) {
                LOGGER.error("Unable to find httpo endpoint for swagger", (Throwable)e);
            }
        }
        String defaultConfigFile = servlet.getInitParameter("config_file");
        SwaggerApiParser apiParser = new SwaggerApiParser(apiHostPort, servlet.getContextPath(), VersionUtils.getVersion(), "GeoWave API", "REST API for GeoWave CLI commands");
        for (RestRoute route : this.availableRoutes) {
            router.attach("/" + route.getPath(), (Restlet)new GeoWaveOperationFinder(route.getOperation(), defaultConfigFile));
            apiParser.addRoute(route);
        }
        String realPath = servlet.getRealPath("/");
        if (!apiParser.serializeSwaggerJson(realPath + "swagger.json")) {
            this.getLogger().warning("Serialization of swagger.json Failed");
        } else {
            this.getLogger().info("Serialization of swagger.json Succeeded");
        }
    }

    private static String getHTTPEndPoint() throws Exception {
        MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
        QueryExp subQuery1 = Query.match(Query.attr("protocol"), Query.value("HTTP/1.1"));
        QueryExp subQuery2 = Query.anySubString(Query.attr("protocol"), Query.value("Http11"));
        QueryExp query = Query.or(subQuery1, subQuery2);
        Set<ObjectName> objs = mbs.queryNames(new ObjectName("*:type=Connector,*"), query);
        String hostname = InetAddress.getLocalHost().getHostName();
        InetAddress[] addresses = InetAddress.getAllByName(hostname);
        Iterator<ObjectName> i = objs.iterator();
        if (i.hasNext()) {
            ObjectName obj = i.next();
            String port = obj.getKeyProperty("port");
            for (InetAddress addr : addresses) {
                if (addr.isAnyLocalAddress() || addr.isLoopbackAddress() || addr.isMulticastAddress()) continue;
                String host = addr.getHostAddress();
                return host + ":" + port;
            }
            return hostname + ":" + port;
        }
        return "localhost:8080";
    }
}

