/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.service;

import java.util.Map;
import javax.ws.rs.Consumes;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;

@Produces(value={"application/json"})
@Path(value="/v0/store")
public interface StoreService {
    @GET
    @Produces(value={"application/json"})
    @Path(value="/listplugins")
    public Response listPlugins();

    @GET
    @Produces(value={"application/json"})
    @Consumes(value={"multipart/form-data"})
    @Path(value="/version")
    public Response version(@QueryParam(value="storeName") String var1);

    @POST
    @Produces(value={"application/json"})
    @Consumes(value={"multipart/form-data"})
    @Path(value="/clear")
    public Response clear(@QueryParam(value="storeName") String var1);

    @POST
    @Produces(value={"application/json"})
    @Path(value="/add/hbase")
    public Response addHBaseStore(@QueryParam(value="name") String var1, @QueryParam(value="zookeeper") String var2, @QueryParam(value="makeDefault") Boolean var3, @QueryParam(value="geowaveNamespace") String var4, @QueryParam(value="disableServiceSide") Boolean var5, @QueryParam(value="coprocessorjar") String var6, @QueryParam(value="persistAdapter") Boolean var7, @QueryParam(value="persistIndex") Boolean var8, @QueryParam(value="persistDataStatistics") Boolean var9, @QueryParam(value="createTable") Boolean var10, @QueryParam(value="useAltIndex") Boolean var11, @QueryParam(value="enableBlockCache") Boolean var12);

    @POST
    @Produces(value={"application/json"})
    @Path(value="/add/accumulo")
    public Response addAccumuloStore(@QueryParam(value="name") String var1, @QueryParam(value="zookeeper") String var2, @QueryParam(value="instance") String var3, @QueryParam(value="user") String var4, @QueryParam(value="password") String var5, @QueryParam(value="makeDefault") Boolean var6, @QueryParam(value="geowaveNamespace") String var7, @QueryParam(value="useLocalityGroups") Boolean var8, @QueryParam(value="persistAdapter") Boolean var9, @QueryParam(value="persistIndex") Boolean var10, @QueryParam(value="persistDataStatistics") Boolean var11, @QueryParam(value="createTable") Boolean var12, @QueryParam(value="useAltIndex") Boolean var13, @QueryParam(value="enableBlockCache") Boolean var14);

    @POST
    @Produces(value={"application/json"})
    @Path(value="/add/bigtable")
    public Response addBigTableStore(@QueryParam(value="name") String var1, @QueryParam(value="makeDefault") Boolean var2, @QueryParam(value="scanCacheSize") Integer var3, @QueryParam(value="projectId") String var4, @QueryParam(value="instanceId") String var5, @QueryParam(value="geowaveNamespace") String var6, @QueryParam(value="useLocalityGroups") Boolean var7, @QueryParam(value="persistAdapter") Boolean var8, @QueryParam(value="persistIndex") Boolean var9, @QueryParam(value="persistDataStatistics") Boolean var10, @QueryParam(value="createTable") Boolean var11, @QueryParam(value="useAltIndex") Boolean var12, @QueryParam(value="enableBlockCache") Boolean var13);

    @POST
    @Produces(value={"application/json"})
    @Path(value="/add/dynamodb")
    public Response addDynamoDBStore(@QueryParam(value="name") String var1, @QueryParam(value="makeDefault") Boolean var2, @QueryParam(value="endpoint") String var3, @QueryParam(value="region") String var4, @QueryParam(value="writeCapacity") Long var5, @QueryParam(value="readCapacity") Long var6, @QueryParam(value="maxConnections") Integer var7, @QueryParam(value="protocol") String var8, @QueryParam(value="enableCacheResponseMetadata") Boolean var9, @QueryParam(value="gwNamespace") String var10, @QueryParam(value="persistAdapter") Boolean var11, @QueryParam(value="persistIndex") Boolean var12, @QueryParam(value="persistDataStatistics") Boolean var13, @QueryParam(value="createTable") Boolean var14, @QueryParam(value="useAltIndex") Boolean var15, @QueryParam(value="enableBlockCache") Boolean var16, @QueryParam(value="enableServerSideLibrary") Boolean var17);

    @POST
    @Produces(value={"application/json"})
    @Path(value="/add/cassandra")
    public Response addCassandraStore(@QueryParam(value="name") String var1, @QueryParam(value="makeDefault") Boolean var2, @QueryParam(value="contactPoint") String var3, @QueryParam(value="batchWriteSize") Integer var4, @QueryParam(value="durableWrites") Boolean var5, @QueryParam(value="replicationFactor") Integer var6, @QueryParam(value="geowaveNamespace") String var7, @QueryParam(value="persistAdapter") Boolean var8, @QueryParam(value="persistIndex") Boolean var9, @QueryParam(value="persistDataStatistics") Boolean var10, @QueryParam(value="createTable") Boolean var11, @QueryParam(value="useAltIndex") Boolean var12, @QueryParam(value="enableBlockCache") Boolean var13, @QueryParam(value="enableServerSideLibrary") Boolean var14);

    @POST
    @Produces(value={"application/json"})
    @Path(value="/add/{type}")
    public Response addStoreReRoute(@QueryParam(value="name") String var1, @PathParam(value="type") String var2, @QueryParam(value="geowaveNamespace") @DefaultValue(value="") String var3, Map<String, String> var4);

    @POST
    @Produces(value={"application/json"})
    @Path(value="/rm")
    public Response removeStore(@QueryParam(value="name") String var1);
}

