/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.service;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(ServiceUtils.class);

    public static Properties loadProperties(InputStream is) {
        Properties props = new Properties();
        if (is != null) {
            try {
                props.load(is);
            }
            catch (IOException e) {
                LOGGER.error("Could not load properties from InputStream", (Throwable)e);
            }
        }
        return props;
    }

    public static String getProperty(Properties props, String name) {
        if (System.getProperty(name) != null) {
            return System.getProperty(name);
        }
        if (props.containsKey(name)) {
            return props.getProperty(name);
        }
        return null;
    }
}

