/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.format.geotools.raster;

import com.beust.jcommander.internal.Maps;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.FilenameUtils;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.io.AbstractGridCoverage2DReader;
import org.geotools.coverage.grid.io.AbstractGridFormat;
import org.geotools.coverage.grid.io.GridCoverage2DReader;
import org.geotools.coverage.grid.io.GridFormatFinder;
import org.geotools.referencing.CRS;
import org.geotools.util.factory.Hints;
import org.locationtech.geowave.adapter.raster.RasterUtils;
import org.locationtech.geowave.adapter.raster.adapter.RasterDataAdapter;
import org.locationtech.geowave.adapter.raster.plugin.GeoWaveGTRasterFormat;
import org.locationtech.geowave.core.store.CloseableIterator;
import org.locationtech.geowave.core.store.api.DataTypeAdapter;
import org.locationtech.geowave.core.store.api.Index;
import org.locationtech.geowave.core.store.ingest.GeoWaveData;
import org.locationtech.geowave.core.store.ingest.LocalFileIngestPlugin;
import org.locationtech.geowave.format.geotools.raster.RasterOptionProvider;
import org.opengis.coverage.Coverage;
import org.opengis.coverage.grid.GridCoverage;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GeoToolsRasterDataStoreIngestPlugin
implements LocalFileIngestPlugin<GridCoverage> {
    private static final Logger LOGGER = LoggerFactory.getLogger(GeoToolsRasterDataStoreIngestPlugin.class);
    private final RasterOptionProvider optionProvider;

    public GeoToolsRasterDataStoreIngestPlugin() {
        this(new RasterOptionProvider());
    }

    public GeoToolsRasterDataStoreIngestPlugin(RasterOptionProvider optionProvider) {
        this.optionProvider = optionProvider;
    }

    public String[] getFileExtensionFilters() {
        return new String[0];
    }

    public void init(URL baseDirectory) {
    }

    public boolean supportsFile(URL file) {
        AbstractGridFormat format = null;
        try {
            format = GridFormatFinder.findFormat((Object)file);
        }
        catch (Exception e) {
            LOGGER.info("Unable to support as raster file", (Throwable)e);
        }
        return format != null && !(format instanceof GeoWaveGTRasterFormat);
    }

    private static AbstractGridFormat prioritizedFindFormat(URL input) {
        AbstractGridFormat format = null;
        try {
            Set formats = GridFormatFinder.findFormats((Object)input);
            if (formats == null || formats.isEmpty()) {
                LOGGER.warn("Unable to support raster file " + input.getPath());
                return null;
            }
            for (AbstractGridFormat f : formats) {
                if (!"GDALGeoTiff".equals(f.getName())) continue;
                return f;
            }
            for (AbstractGridFormat f : formats) {
                if (!"GeoTIFF".equals(f.getName())) continue;
                return f;
            }
            Iterator it = formats.iterator();
            if (it.hasNext()) {
                return (AbstractGridFormat)it.next();
            }
        }
        catch (Exception e) {
            LOGGER.warn("Error while trying read raster file", (Throwable)e);
            return null;
        }
        return format;
    }

    public CloseableIterator<GeoWaveData<GridCoverage>> toGeoWaveData(URL input, String[] indexNames) {
        AbstractGridCoverage2DReader reader;
        AbstractGridFormat format = GeoToolsRasterDataStoreIngestPlugin.prioritizedFindFormat(input);
        if (format == null) {
            return new CloseableIterator.Wrapper(Collections.emptyIterator());
        }
        Hints hints = null;
        if (this.optionProvider.getCrs() != null && !this.optionProvider.getCrs().trim().isEmpty()) {
            try {
                CoordinateReferenceSystem crs = CRS.decode((String)this.optionProvider.getCrs());
                if (crs != null) {
                    hints = new Hints();
                    hints.put((Object)Hints.DEFAULT_COORDINATE_REFERENCE_SYSTEM, (Object)crs);
                }
            }
            catch (Exception e) {
                LOGGER.warn("Unable to find coordinate reference system, continuing without hint", (Throwable)e);
            }
        }
        if ((reader = format.getReader((Object)input, hints)) == null) {
            LOGGER.error("Unable to get reader instance, getReader returned null");
            return new CloseableIterator.Wrapper(Collections.emptyIterator());
        }
        try {
            GridCoverage2D coverage = reader.read(null);
            if (coverage != null) {
                HashMap<String, String> metadata = new HashMap<String, String>();
                String coverageName = coverage.getName().toString();
                try {
                    String[] mdNames = reader.getMetadataNames(coverageName);
                    if (mdNames != null && mdNames.length > 0) {
                        for (String mdName : mdNames) {
                            String value;
                            if (mdName == null || (value = reader.getMetadataValue(coverageName, mdName)) == null) continue;
                            metadata.put(mdName, value);
                        }
                    }
                }
                catch (Exception e) {
                    LOGGER.debug("Unable to find metadata from coverage reader", (Throwable)e);
                }
                ArrayList<GeoWaveData> coverages = new ArrayList<GeoWaveData>();
                if (this.optionProvider.isSeparateBands() && coverage.getNumSampleDimensions() > 1) {
                    String baseName = this.optionProvider.getCoverageName() != null ? this.optionProvider.getCoverageName() : FilenameUtils.getName((String)input.getPath());
                    double[][] nodata = this.optionProvider.getNodata(coverage.getNumSampleDimensions());
                    for (int b = 0; b < coverage.getNumSampleDimensions(); ++b) {
                        RasterDataAdapter adapter = new RasterDataAdapter(baseName + "_B" + b, metadata, (GridCoverage2D)RasterUtils.getCoverageOperations().selectSampleDimension((Coverage)coverage, new int[]{b}), this.optionProvider.getTileSize(), this.optionProvider.isBuildPyramid(), this.optionProvider.isBuildHistogram(), (double[][])new double[][]{nodata[b]});
                        coverages.add(new GeoWaveData((DataTypeAdapter)adapter, indexNames, (Object)coverage));
                    }
                } else {
                    RasterDataAdapter adapter = new RasterDataAdapter(this.optionProvider.getCoverageName() != null ? this.optionProvider.getCoverageName() : input.getPath(), metadata, coverage, this.optionProvider.getTileSize(), this.optionProvider.isBuildPyramid(), this.optionProvider.isBuildHistogram(), this.optionProvider.getNodata(coverage.getNumSampleDimensions()));
                    coverages.add(new GeoWaveData((DataTypeAdapter)adapter, indexNames, (Object)coverage));
                }
                return new CloseableIterator.Wrapper<GeoWaveData<GridCoverage>>(coverages.iterator(), (GridCoverage2DReader)reader){
                    final /* synthetic */ GridCoverage2DReader val$reader;
                    {
                        this.val$reader = gridCoverage2DReader;
                        super(x0);
                    }

                    public void close() {
                        try {
                            this.val$reader.dispose();
                        }
                        catch (IOException e) {
                            LOGGER.warn("unable to dispose of reader resources", (Throwable)e);
                        }
                    }
                };
            }
            LOGGER.warn("Null grid coverage from file '" + input.getPath() + "' for discovered geotools format '" + format.getName() + "'");
        }
        catch (IOException e) {
            LOGGER.warn("Unable to read grid coverage of file '" + input.getPath() + "' for discovered geotools format '" + format.getName() + "'", (Throwable)e);
        }
        return new CloseableIterator.Wrapper(Collections.emptyIterator());
    }

    public DataTypeAdapter<GridCoverage>[] getDataAdapters() {
        return new RasterDataAdapter[0];
    }

    public DataTypeAdapter<GridCoverage>[] getDataAdapters(URL url) {
        Map adapters = Maps.newHashMap();
        try (CloseableIterator<GeoWaveData<GridCoverage>> dataIt = this.toGeoWaveData(url, new String[0]);){
            while (dataIt.hasNext()) {
                DataTypeAdapter adapter = ((GeoWaveData)dataIt.next()).getAdapter();
                adapters.put(adapter.getTypeName(), adapter);
            }
        }
        return (DataTypeAdapter[])adapters.values().toArray(new RasterDataAdapter[adapters.size()]);
    }

    public Index[] getRequiredIndices() {
        return new Index[0];
    }

    public String[] getSupportedIndexTypes() {
        return new String[]{"default_geom_dimension"};
    }
}

