/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.datastore.rocksdb.util;

import com.google.common.collect.Streams;
import com.google.common.primitives.UnsignedBytes;
import java.io.File;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;
import org.locationtech.geowave.core.index.ByteArray;
import org.locationtech.geowave.core.index.ByteArrayUtils;
import org.locationtech.geowave.core.store.adapter.InternalDataAdapter;
import org.locationtech.geowave.core.store.adapter.RowMergingDataAdapter;
import org.locationtech.geowave.core.store.base.dataidx.DataIndexUtils;
import org.locationtech.geowave.core.store.entities.GeoWaveRow;
import org.locationtech.geowave.core.store.operations.MetadataType;
import org.locationtech.geowave.core.store.operations.RangeReaderParams;
import org.locationtech.geowave.datastore.rocksdb.util.RocksDBClient;
import org.locationtech.geowave.datastore.rocksdb.util.RocksDBDataIndexTable;
import org.locationtech.geowave.datastore.rocksdb.util.RocksDBIndexTable;
import org.locationtech.geowave.datastore.rocksdb.util.RocksDBMetadataTable;

public class RocksDBUtils {
    protected static final int MAX_ROWS_FOR_PAGINATION = 1000000;
    public static int ROCKSDB_DEFAULT_MAX_RANGE_DECOMPOSITION = 250;
    public static int ROCKSDB_DEFAULT_AGGREGATION_MAX_RANGE_DECOMPOSITION = 250;
    public static ByteArray EMPTY_PARTITION_KEY = new ByteArray();

    public static RocksDBMetadataTable getMetadataTable(RocksDBClient client, MetadataType metadataType) {
        return client.getMetadataTable(metadataType);
    }

    public static String getTablePrefix(String typeName, String indexName) {
        return typeName + "_" + indexName;
    }

    public static RocksDBDataIndexTable getDataIndexTable(RocksDBClient client, String typeName, short adapterId) {
        return client.getDataIndexTable(RocksDBUtils.getTablePrefix(typeName, DataIndexUtils.DATA_ID_INDEX.getName()), adapterId);
    }

    public static RocksDBIndexTable getIndexTableFromPrefix(RocksDBClient client, String namePrefix, short adapterId, byte[] partitionKey, boolean requiresTimestamp) {
        return RocksDBUtils.getIndexTable(client, RocksDBUtils.getTableName(namePrefix, partitionKey), adapterId, partitionKey, requiresTimestamp);
    }

    public static String getTableName(String typeName, String indexName, byte[] partitionKey) {
        return RocksDBUtils.getTableName(RocksDBUtils.getTablePrefix(typeName, indexName), partitionKey);
    }

    public static String getTableName(String setNamePrefix, byte[] partitionKey) {
        String partitionStr = partitionKey != null && partitionKey.length > 0 ? "_" + ByteArrayUtils.byteArrayToString((byte[])partitionKey) : "";
        return setNamePrefix + partitionStr;
    }

    public static RocksDBIndexTable getIndexTable(RocksDBClient client, String tableName, short adapterId, byte[] partitionKey, boolean requiresTimestamp) {
        return client.getIndexTable(tableName, adapterId, partitionKey, requiresTimestamp);
    }

    public static RocksDBIndexTable getIndexTable(RocksDBClient client, String typeName, String indexName, short adapterId, byte[] partitionKey, boolean requiresTimestamp) {
        return RocksDBUtils.getIndexTable(client, RocksDBUtils.getTablePrefix(typeName, indexName), adapterId, partitionKey, requiresTimestamp);
    }

    public static Set<ByteArray> getPartitions(String directory, String tableNamePrefix) {
        return Arrays.stream(new File(directory).list((dir, name) -> name.startsWith(tableNamePrefix))).map(str -> str.length() > tableNamePrefix.length() + 1 ? new ByteArray(ByteArrayUtils.byteArrayFromString((String)str.substring(tableNamePrefix.length() + 1))) : new ByteArray()).collect(Collectors.toSet());
    }

    public static boolean isSortByTime(InternalDataAdapter<?> adapter) {
        return adapter.getAdapter() instanceof RowMergingDataAdapter;
    }

    public static boolean isSortByKeyRequired(RangeReaderParams<?> params) {
        return params.getMaxResolutionSubsamplingPerDimension() != null && params.getMaxResolutionSubsamplingPerDimension().length > 0;
    }

    public static Iterator<GeoWaveRow> sortBySortKey(Iterator<GeoWaveRow> it) {
        return Streams.stream(it).sorted(SortKeyOrder.SINGLETON).iterator();
    }

    public static Pair<Boolean, Boolean> isGroupByRowAndIsSortByTime(RangeReaderParams<?> readerParams, short adapterId) {
        boolean sortByTime = RocksDBUtils.isSortByTime((InternalDataAdapter)readerParams.getAdapterStore().getAdapter((Object)adapterId));
        return Pair.of((Object)(readerParams.isMixedVisibility() || sortByTime ? 1 : 0), (Object)sortByTime);
    }

    private static class SortKeyOrder
    implements Comparator<GeoWaveRow>,
    Serializable {
        private static SortKeyOrder SINGLETON = new SortKeyOrder();
        private static final long serialVersionUID = 23275155231L;

        private SortKeyOrder() {
        }

        @Override
        public int compare(GeoWaveRow o1, GeoWaveRow o2) {
            if (o1 == o2) {
                return 0;
            }
            if (o1 == null) {
                return 1;
            }
            if (o2 == null) {
                return -1;
            }
            byte[] otherComp = o2.getSortKey() == null ? new byte[]{} : o2.getSortKey();
            byte[] thisComp = o1.getSortKey() == null ? new byte[]{} : o1.getSortKey();
            int comp = UnsignedBytes.lexicographicalComparator().compare(thisComp, otherComp);
            if (comp != 0) {
                return comp;
            }
            otherComp = o2.getPartitionKey() == null ? new byte[]{} : o2.getPartitionKey();
            thisComp = o1.getPartitionKey() == null ? new byte[]{} : o1.getPartitionKey();
            comp = UnsignedBytes.lexicographicalComparator().compare(thisComp, otherComp);
            if (comp != 0) {
                return comp;
            }
            comp = Short.compare(o1.getAdapterId(), o2.getAdapterId());
            if (comp != 0) {
                return comp;
            }
            otherComp = o2.getDataId() == null ? new byte[]{} : o2.getDataId();
            thisComp = o1.getDataId() == null ? new byte[]{} : o1.getDataId();
            comp = UnsignedBytes.lexicographicalComparator().compare(thisComp, otherComp);
            if (comp != 0) {
                return comp;
            }
            return Integer.compare(o1.getNumberOfDuplicates(), o2.getNumberOfDuplicates());
        }
    }
}

