/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.datastore.rocksdb.util;

import com.google.common.collect.Lists;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.ArrayUtils;
import org.locationtech.geowave.core.index.ByteArrayUtils;
import org.locationtech.geowave.core.store.entities.GeoWaveRow;
import org.locationtech.geowave.core.store.entities.GeoWaveValue;
import org.locationtech.geowave.core.store.entities.GeoWaveValueImpl;
import org.locationtech.geowave.core.store.entities.MergeableGeoWaveRow;

public class RocksDBRow
extends MergeableGeoWaveRow
implements GeoWaveRow {
    List<byte[]> mergedKeys;
    private final byte[] key;
    private final short adapterId;
    private final byte[] partition;
    private final byte[] sortKey;
    private final byte[] dataId;
    private final short duplicates;

    public RocksDBRow(short adapterId, byte[] partition, byte[] key, byte[] value, boolean containsTimestamp, boolean visibilityEnabled) {
        byte[] visibility;
        int otherBytes = 4;
        this.adapterId = adapterId;
        this.partition = partition;
        this.key = key;
        ByteBuffer buf = ByteBuffer.wrap(key);
        this.sortKey = new byte[key[key.length - 2]];
        buf.get(this.sortKey);
        byte[] fieldMask = new byte[key[key.length - 1]];
        if (visibilityEnabled) {
            visibility = new byte[key[key.length - 3]];
            ++otherBytes;
        } else {
            visibility = new byte[]{};
        }
        if (containsTimestamp) {
            otherBytes += 8;
        }
        this.dataId = new byte[key.length - otherBytes - this.sortKey.length - fieldMask.length - visibility.length];
        buf.get(this.dataId);
        if (containsTimestamp) {
            buf.position(buf.position() + 8);
        }
        buf.get(fieldMask);
        if (visibilityEnabled) {
            buf.get(visibility);
        }
        byte[] duplicatesBytes = new byte[2];
        buf.get(duplicatesBytes);
        this.duplicates = ByteArrayUtils.byteArrayToShort((byte[])duplicatesBytes);
        this.attributeValues = Lists.newArrayList((Object[])new GeoWaveValue[]{new GeoWaveValueImpl(fieldMask, visibility, value)});
    }

    public byte[] getDataId() {
        return this.dataId;
    }

    public short getAdapterId() {
        return this.adapterId;
    }

    public byte[] getSortKey() {
        return this.sortKey;
    }

    public byte[] getPartitionKey() {
        return this.partition;
    }

    public int getNumberOfDuplicates() {
        return this.duplicates;
    }

    public byte[][] getKeys() {
        if (this.mergedKeys == null) {
            return new byte[][]{this.key};
        }
        return (byte[][])ArrayUtils.add((Object[])this.mergedKeys.toArray((T[])new byte[0][]), (Object)this.key);
    }

    public void mergeRow(MergeableGeoWaveRow row) {
        super.mergeRow(row);
        if (row instanceof RocksDBRow) {
            if (this.mergedKeys == null) {
                this.mergedKeys = new ArrayList<byte[]>();
            }
            Arrays.stream(((RocksDBRow)row).getKeys()).forEach(r -> this.mergedKeys.add((byte[])r));
        }
    }
}

