/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.datastore.rocksdb.util;

import com.google.common.primitives.Bytes;
import com.google.common.primitives.Longs;
import org.locationtech.geowave.core.store.CloseableIterator;
import org.locationtech.geowave.core.store.entities.GeoWaveMetadata;
import org.locationtech.geowave.datastore.rocksdb.util.RocksDBMetadataIterator;
import org.rocksdb.ReadOptions;
import org.rocksdb.RocksDB;
import org.rocksdb.RocksDBException;
import org.rocksdb.RocksIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RocksDBMetadataTable {
    private static final Logger LOGGER = LoggerFactory.getLogger(RocksDBMetadataTable.class);
    private final RocksDB db;
    private final boolean requiresTimestamp;
    private final boolean visibilityEnabled;
    private final boolean compactOnWrite;
    private long prevTime = Long.MAX_VALUE;

    public RocksDBMetadataTable(RocksDB db, boolean requiresTimestamp, boolean visibilityEnabled, boolean compactOnWrite) {
        this.db = db;
        this.requiresTimestamp = requiresTimestamp;
        this.visibilityEnabled = visibilityEnabled;
        this.compactOnWrite = compactOnWrite;
    }

    public void remove(byte[] key) {
        try {
            this.db.singleDelete(key);
        }
        catch (RocksDBException e) {
            LOGGER.warn("Unable to delete metadata", (Throwable)e);
        }
    }

    public void add(GeoWaveMetadata value) {
        byte[] key;
        byte[] endBytes;
        byte[] secondaryId;
        byte[] byArray = secondaryId = value.getSecondaryId() == null ? new byte[]{} : value.getSecondaryId();
        if (this.visibilityEnabled) {
            byte[] visibility = value.getVisibility() == null ? new byte[]{} : value.getVisibility();
            endBytes = Bytes.concat((byte[][])new byte[][]{visibility, {(byte)visibility.length, (byte)value.getPrimaryId().length}});
        } else {
            endBytes = new byte[]{(byte)value.getPrimaryId().length};
        }
        if (this.requiresTimestamp) {
            long time = Long.MAX_VALUE - System.currentTimeMillis();
            if (time >= this.prevTime) {
                time = this.prevTime - 1L;
            }
            this.prevTime = time;
            key = Bytes.concat((byte[][])new byte[][]{value.getPrimaryId(), secondaryId, Longs.toByteArray((long)time), endBytes});
        } else {
            key = Bytes.concat((byte[][])new byte[][]{value.getPrimaryId(), secondaryId, endBytes});
        }
        this.put(key, value.getValue());
    }

    public void compact() {
        try {
            this.db.compactRange();
        }
        catch (RocksDBException e) {
            LOGGER.warn("Unable to force compacting metadata", (Throwable)e);
        }
    }

    public CloseableIterator<GeoWaveMetadata> iterator(byte[] primaryId) {
        return this.prefixIterator(primaryId);
    }

    public CloseableIterator<GeoWaveMetadata> iterator(byte[] primaryId, byte[] secondaryId) {
        return this.prefixIterator(Bytes.concat((byte[][])new byte[][]{primaryId, secondaryId}));
    }

    private CloseableIterator<GeoWaveMetadata> prefixIterator(byte[] prefix) {
        ReadOptions options = new ReadOptions().setPrefixSameAsStart(true);
        RocksIterator it = this.db.newIterator(options);
        it.seek(prefix);
        return new RocksDBMetadataIterator(options, it, this.requiresTimestamp, this.visibilityEnabled);
    }

    public CloseableIterator<GeoWaveMetadata> iterator() {
        RocksIterator it = this.db.newIterator();
        it.seekToFirst();
        return new RocksDBMetadataIterator(it, this.requiresTimestamp, this.visibilityEnabled);
    }

    public void put(byte[] key, byte[] value) {
        try {
            this.db.put(key, value);
        }
        catch (RocksDBException e) {
            LOGGER.warn("Unable to add metadata", (Throwable)e);
        }
    }

    public void flush() {
        if (this.compactOnWrite) {
            try {
                this.db.compactRange();
            }
            catch (RocksDBException e) {
                LOGGER.warn("Unable to compact metadata", (Throwable)e);
            }
        }
    }

    public void close() {
        this.db.close();
    }
}

