/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.datastore.rocksdb.util;

import java.nio.ByteBuffer;
import org.locationtech.geowave.core.store.entities.GeoWaveMetadata;
import org.locationtech.geowave.datastore.rocksdb.util.AbstractRocksDBIterator;
import org.locationtech.geowave.datastore.rocksdb.util.RocksDBGeoWaveMetadata;
import org.rocksdb.ReadOptions;
import org.rocksdb.RocksIterator;

public class RocksDBMetadataIterator
extends AbstractRocksDBIterator<GeoWaveMetadata> {
    private final boolean containsTimestamp;
    private final boolean visibilityEnabled;

    public RocksDBMetadataIterator(RocksIterator it, boolean containsTimestamp, boolean visibilityEnabled) {
        this(null, it, containsTimestamp, visibilityEnabled);
    }

    public RocksDBMetadataIterator(ReadOptions options, RocksIterator it, boolean containsTimestamp, boolean visibilityEnabled) {
        super(options, it);
        this.options = options;
        this.it = it;
        this.containsTimestamp = containsTimestamp;
        this.visibilityEnabled = visibilityEnabled;
    }

    @Override
    protected GeoWaveMetadata readRow(byte[] key, byte[] value) {
        ByteBuffer buf = ByteBuffer.wrap(key);
        byte[] primaryId = new byte[Byte.toUnsignedInt(key[key.length - 1])];
        byte[] visibility = this.visibilityEnabled ? new byte[Byte.toUnsignedInt(key[key.length - 2])] : new byte[]{};
        int secondaryIdLength = key.length - primaryId.length - visibility.length - 1;
        if (this.containsTimestamp) {
            secondaryIdLength -= 8;
        }
        if (this.visibilityEnabled) {
            --secondaryIdLength;
        }
        byte[] secondaryId = new byte[secondaryIdLength];
        buf.get(primaryId);
        buf.get(secondaryId);
        if (this.containsTimestamp) {
            buf.position(buf.position() + 8);
        }
        if (this.visibilityEnabled) {
            buf.get(visibility);
        }
        return new RocksDBGeoWaveMetadata(primaryId, secondaryId, visibility, value, key);
    }
}

