/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.datastore.rocksdb.util;

import com.google.common.primitives.Bytes;
import com.google.common.primitives.Longs;
import org.locationtech.geowave.core.index.ByteArrayRange;
import org.locationtech.geowave.core.index.ByteArrayUtils;
import org.locationtech.geowave.core.store.CloseableIterator;
import org.locationtech.geowave.core.store.entities.GeoWaveRow;
import org.locationtech.geowave.core.store.entities.GeoWaveValue;
import org.locationtech.geowave.datastore.rocksdb.util.AbstractRocksDBTable;
import org.locationtech.geowave.datastore.rocksdb.util.RocksDBRowIterator;
import org.rocksdb.Options;
import org.rocksdb.ReadOptions;
import org.rocksdb.RocksDB;
import org.rocksdb.RocksDBException;
import org.rocksdb.RocksIterator;
import org.rocksdb.Slice;
import org.rocksdb.WriteOptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RocksDBIndexTable
extends AbstractRocksDBTable {
    private static final Logger LOGGER = LoggerFactory.getLogger(RocksDBIndexTable.class);
    private long prevTime = Long.MAX_VALUE;
    private final boolean requiresTimestamp;
    private final byte[] partition;

    public RocksDBIndexTable(Options writeOptions, WriteOptions batchWriteOptions, String subDirectory, short adapterId, byte[] partition, boolean requiresTimestamp, boolean visibilityEnabled, boolean compactOnWrite, int batchSize) {
        super(writeOptions, batchWriteOptions, subDirectory, adapterId, visibilityEnabled, compactOnWrite, batchSize);
        this.requiresTimestamp = requiresTimestamp;
        this.partition = partition;
    }

    public void delete(byte[] sortKey, byte[] dataId) {
        RocksDB db = this.getDb(false);
        if (db == null) {
            LOGGER.warn("Unable to delete key because directory '" + this.subDirectory + "' doesn't exist");
            return;
        }
        try {
            byte[] prefix = Bytes.concat((byte[][])new byte[][]{sortKey, dataId});
            db.deleteRange(prefix, ByteArrayUtils.getNextPrefix((byte[])prefix));
        }
        catch (RocksDBException e) {
            LOGGER.warn("Unable to delete by sort key and data ID", (Throwable)e);
        }
    }

    public synchronized void add(byte[] sortKey, byte[] dataId, short numDuplicates, GeoWaveValue value) {
        byte[] key;
        byte[] endBytes = this.visibilityEnabled ? Bytes.concat((byte[][])new byte[][]{value.getVisibility(), ByteArrayUtils.shortToByteArray((short)numDuplicates), {(byte)value.getVisibility().length, (byte)sortKey.length, (byte)value.getFieldMask().length}}) : Bytes.concat((byte[][])new byte[][]{ByteArrayUtils.shortToByteArray((short)numDuplicates), {(byte)sortKey.length, (byte)value.getFieldMask().length}});
        if (this.requiresTimestamp) {
            long time = Long.MAX_VALUE - System.currentTimeMillis();
            if (time >= this.prevTime) {
                time = this.prevTime - 1L;
            }
            this.prevTime = time;
            key = Bytes.concat((byte[][])new byte[][]{sortKey, dataId, Longs.toByteArray((long)time), value.getFieldMask(), endBytes});
        } else {
            key = Bytes.concat((byte[][])new byte[][]{sortKey, dataId, value.getFieldMask(), endBytes});
        }
        this.put(key, value.getValue());
    }

    public CloseableIterator<GeoWaveRow> iterator() {
        RocksDB readDb = this.getDb(true);
        if (readDb == null) {
            return new CloseableIterator.Empty();
        }
        ReadOptions options = new ReadOptions().setFillCache(false);
        RocksIterator it = readDb.newIterator(options);
        it.seekToFirst();
        return new RocksDBRowIterator(options, it, this.adapterId, this.partition, this.requiresTimestamp, this.visibilityEnabled);
    }

    public CloseableIterator<GeoWaveRow> iterator(ByteArrayRange range) {
        RocksIterator it;
        ReadOptions options;
        RocksDB readDb = this.getDb(true);
        if (readDb == null) {
            return new CloseableIterator.Empty();
        }
        if (range.getEnd() == null) {
            options = null;
            it = readDb.newIterator();
        } else {
            options = new ReadOptions().setIterateUpperBound(new Slice(range.getEndAsNextPrefix()));
            it = readDb.newIterator(options);
        }
        if (range.getStart() == null) {
            it.seekToFirst();
        } else {
            it.seek(range.getStart());
        }
        return new RocksDBRowIterator(options, it, this.adapterId, this.partition, this.requiresTimestamp, this.visibilityEnabled);
    }
}

